/*
 * Decompiled with CFR 0.152.
 */
package com.frxnklxrd.enchanter.utilities;

import com.frxnklxrd.enchanter.Main;
import com.frxnklxrd.enchanter.enchant.Enchanter;
import com.frxnklxrd.enchanter.enchant.EnchanterNBT;
import com.frxnklxrd.enchanter.utilities.Utils;
import de.tr7zw.nbtapi.NBTItem;
import dev.drawethree.ultraprisoncore.enchants.UltraPrisonEnchants;
import dev.drawethree.ultraprisoncore.enchants.model.UltraPrisonEnchantment;
import me.revils.revenchants.api.RevEnchantsApi;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Enchants {
    public static String getRawName(int enchant) {
        if (Utils.checkDependency().equalsIgnoreCase("UltraPrisonCore")) {
            return Enchants.getConfig().getString("enchants." + enchant + ".RawName");
        }
        if (Utils.checkDependency().equalsIgnoreCase("EdPrison")) {
            return "Not available";
        }
        return "Not available";
    }

    public static String getName(ItemStack item) {
        NBTItem nbt = new NBTItem(item);
        if (nbt.hasKey(Enchanter.nbtEnchant).booleanValue()) {
            if (Utils.checkDependency().equalsIgnoreCase("UltraPrisonCore")) {
                return Utils.getColor(Enchants.getConfig().getString("enchants." + new EnchanterNBT(item).getEnchantUPC() + ".Name"));
            }
            if (Utils.checkDependency().equalsIgnoreCase("EdPrison")) {
                return nbt.getString(Enchanter.nbtEnchant);
            }
            if (Utils.checkDependency().equalsIgnoreCase("RevEnchants")) {
                return nbt.getString(Enchanter.nbtEnchant);
            }
        }
        return "Not available";
    }

    public static boolean hasEnchant(ItemStack item, int enchant) {
        UltraPrisonEnchantment var1 = UltraPrisonEnchants.getInstance().getApi().getById(enchant);
        return Main.getUltraPrisonCore().getEnchants().getEnchantsManager().getEnchantLevel(item, var1) != 0;
    }

    public static boolean hasEnchant(Player p, int enchant) {
        UltraPrisonEnchantment var1 = UltraPrisonEnchants.getInstance().getApi().getById(enchant);
        return Main.getUltraPrisonCore().getEnchants().getApi().hasEnchant(p.getInventory().getItemInMainHand(), var1);
    }

    public static int getEnchantLevel(ItemStack item, int enchant) {
        UltraPrisonEnchantment var1 = UltraPrisonEnchants.getInstance().getApi().getById(enchant);
        return Main.getUltraPrisonCore().getEnchants().getEnchantsManager().getEnchantLevel(item, var1);
    }

    public static int getMaxLevel(String enchant) {
        if (Utils.checkDependency().equalsIgnoreCase("UltraPrisonCore")) {
            return Enchants.getConfig().getInt("enchants." + enchant + ".Max");
        }
        if (Utils.checkDependency().equalsIgnoreCase("EdPrison")) {
            return Main.getEdPrison().getEnchantments().getInt("Enchantments." + enchant + ".maxLevel");
        }
        if (Utils.checkDependency().equalsIgnoreCase("RevEnchants")) {
            return RevEnchantsApi.getEnchantsYml((String)enchant).getInt("Settings.MaxLevel");
        }
        return 0;
    }

    public static YamlConfiguration getConfig() {
        return Main.getUltraPrisonCore().getEnchants().getEnchantsConfig().getYamlConfig();
    }
}

