/*
 * Decompiled with CFR 0.152.
 */
package com.frxnklxrd.enchanter.mystery;

import com.frxnklxrd.enchanter.enchant.Enchanter;
import com.frxnklxrd.enchanter.mystery.MysteryConfig;
import com.frxnklxrd.enchanter.utilities.Utils;
import de.tr7zw.nbtapi.NBTItem;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Mystery {
    private final ItemStack mystery;
    private final String tier;
    public String enchant;
    public static final String nbtTier = "enchanter-mystery";
    public static final String nbtEnchant = "enchanter-mystery-enchant";

    public Mystery(String var1) {
        this.tier = var1;
        this.mystery = new ItemStack(this.getMaterial());
    }

    public Mystery(ItemStack item) {
        this.mystery = item;
        this.tier = this.getTier();
        this.enchant = this.getRandomEnchant();
    }

    public Mystery setTier(String var1) {
        NBTItem nbt = new NBTItem(this.mystery);
        nbt.setString(nbtTier, this.tier);
        nbt.applyNBT(this.mystery);
        return this;
    }

    public String getTier() {
        NBTItem nbt = new NBTItem(this.mystery);
        return nbt.hasKey(nbtTier) != false ? nbt.getString(nbtTier) : Enchanter.getCustomTier();
    }

    private Mystery setEnchant(String var1) {
        NBTItem nbt = new NBTItem(this.mystery);
        nbt.setString(nbtEnchant, var1);
        nbt.applyNBT(this.mystery);
        return this;
    }

    private String getEnchant() {
        NBTItem nbt = new NBTItem(this.mystery);
        return nbt.hasKey(nbtEnchant) != false ? nbt.getString(nbtEnchant) : "None";
    }

    public void createMystery(Player p, int amount) {
        ItemMeta meta = this.mystery.getItemMeta();
        meta.setDisplayName(this.getName());
        List lore = MysteryConfig.getConfig().getStringList("Mystery.Tiers." + this.tier + ".Lore");
        lore.replaceAll(Utils::hexColor);
        meta.setLore(lore);
        if (MysteryConfig.getConfig().contains("Mystery.Tiers." + this.tier + ".CustomModelData")) {
            meta.setCustomModelData(Integer.valueOf(MysteryConfig.getConfig().getInt("Mystery.Tiers." + this.tier + ".CustomModelData")));
        }
        if (MysteryConfig.getConfig().getBoolean("Mystery.Tiers." + this.tier + ".Glow")) {
            meta.addEnchant(Enchantment.LOOT_BONUS_BLOCKS, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        this.mystery.setItemMeta(meta);
        this.mystery.setAmount(amount);
        p.getInventory().addItem(new ItemStack[]{this.mystery});
    }

    public String getMode() {
        return MysteryConfig.getConfig().getString("Mystery.Tiers." + this.tier + ".Enchants.Type");
    }

    public int getRandomAmount() {
        if (this.getMode().equalsIgnoreCase("list")) {
            int m1 = MysteryConfig.getConfig().getInt("Mystery.Tiers." + this.tier + ".Enchants.MinAmount");
            int m2 = MysteryConfig.getConfig().getInt("Mystery.Tiers." + this.tier + ".Enchants.MaxAmount");
            return ThreadLocalRandom.current().nextInt(m1, m2);
        }
        if (this.getMode().equalsIgnoreCase("custom")) {
            int m1 = MysteryConfig.getConfig().getInt("Mystery.Tiers." + this.tier + ".Enchants.Custom." + this.enchant + ".MinAmount");
            int m2 = MysteryConfig.getConfig().getInt("Mystery.Tiers." + this.tier + ".Enchants.Custom." + this.enchant + ".MaxAmount");
            return ThreadLocalRandom.current().nextInt(m1, m2);
        }
        return 0;
    }

    private String getRandomEnchant() {
        if (this.getMode().equalsIgnoreCase("list")) {
            List enchants = MysteryConfig.getConfig().getStringList("Mystery.Tiers." + this.tier + ".Enchants.List");
            return (String)enchants.get(ThreadLocalRandom.current().nextInt(enchants.size()));
        }
        if (this.getMode().equalsIgnoreCase("custom")) {
            ArrayList enchants = new ArrayList(MysteryConfig.getConfig().getConfigurationSection("Mystery.Tiers." + this.tier + ".Enchants.Custom").getKeys(false));
            return (String)enchants.get(ThreadLocalRandom.current().nextInt(enchants.size()));
        }
        return "None";
    }

    public int getRandomChance() {
        if (this.getMode().equalsIgnoreCase("list")) {
            if (MysteryConfig.getConfig().getBoolean("Mystery.Tiers." + this.tier + ".Enchants.Chance.Random")) {
                return ThreadLocalRandom.current().nextInt(1, 100);
            }
            int m1 = MysteryConfig.getConfig().getInt("Mystery.Tiers." + this.tier + ".Enchants.Chance.MinChance");
            int m2 = MysteryConfig.getConfig().getInt("Mystery.Tiers." + this.tier + ".Enchants.Chance.MaxChance");
            return m1 == 100 && m2 == 100 ? 100 : ThreadLocalRandom.current().nextInt(m1, m2);
        }
        if (this.getMode().equalsIgnoreCase("custom")) {
            if (MysteryConfig.getConfig().getBoolean("Mystery.Tiers." + this.tier + ".Enchants.Custom." + this.enchant + ".Chance.Random")) {
                return ThreadLocalRandom.current().nextInt(1, 100);
            }
            int m1 = MysteryConfig.getConfig().getInt("Mystery.Tiers." + this.tier + ".Enchants.Custom." + this.enchant + "Chance.MinChance");
            int m2 = MysteryConfig.getConfig().getInt("Mystery.Tiers." + this.tier + ".Enchants.Custom." + this.enchant + ".Chance.MaxChance");
            return m1 == 100 && m2 == 100 ? 100 : ThreadLocalRandom.current().nextInt(m1, m2);
        }
        return 0;
    }

    public static boolean isMystery(ItemStack item) {
        NBTItem nbt = new NBTItem(item);
        return nbt.hasKey(nbtTier);
    }

    private Material getMaterial() {
        return Material.getMaterial((String)MysteryConfig.getConfig().getString("Mystery.Tiers." + this.tier + ".Material"));
    }

    private String getName() {
        return Utils.hexColor(MysteryConfig.getConfig().getString("Mystery.Tiers." + this.tier + ".Name"));
    }
}

