/*
 * Decompiled with CFR 0.152.
 */
package com.frxnklxrd.enchanter.enchant;

import com.frxnklxrd.enchanter.Main;
import com.frxnklxrd.enchanter.enchant.EnchanterNBT;
import com.frxnklxrd.enchanter.utilities.Enchants;
import com.frxnklxrd.enchanter.utilities.Utils;
import de.tr7zw.nbtapi.NBTItem;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Enchanter {
    public static String nbtEnchant = "enchanter-enchant";
    public static String nbtAmount = "enchanter-amount";
    public static String nbtSuccess = "enchanter-success";
    public static String nbtTier = "enchanter-tier";
    private final ItemStack enchanter;
    private final String tierName;

    public Enchanter(ItemStack var1) {
        this.enchanter = var1;
        NBTItem nbt = new NBTItem(var1);
        this.tierName = nbt.getString(nbtTier);
    }

    public Enchanter(String var1) {
        this.enchanter = new ItemStack(Objects.requireNonNull(Material.getMaterial((String)Objects.requireNonNull(Main.getInstance().getConfig().getString("Config.Enchanter." + var1 + ".Material")))));
        this.tierName = var1;
    }

    public Enchanter() {
        this.tierName = "default";
        this.enchanter = new ItemStack(Objects.requireNonNull(Material.getMaterial((String)Objects.requireNonNull(Main.getInstance().getConfig().getString("Config.Enchanter." + this.tierName + ".Material")))));
    }

    public void createEnchanter(Player p, int amount) {
        int var1 = this.getNBT().getEnchantUPC();
        String var2 = Main.getInstance().getConfig().contains("Config.CustomNames." + var1) ? Utils.hexColor(Main.getInstance().getConfig().getString("Config.CustomNames." + var1)) : "Not Available";
        ItemMeta meta = this.enchanter.getItemMeta();
        String name = Utils.hexColor(Objects.requireNonNull(Main.getInstance().getConfig().getString("Config.Enchanter." + this.tierName + ".Name")).replace("%rawname%", Enchants.getRawName(this.getNBT().getEnchantUPC())).replace("%customname%", var2).replace("%amount%", this.getNBT().getAmount() + "").replace("%name%", Enchants.getName(this.enchanter)));
        meta.setDisplayName(name);
        List lore = Main.getInstance().getConfig().getStringList("Config.Enchanter." + this.tierName + ".Lore");
        lore.replaceAll(s -> Utils.hexColor(s.replace("%amount%", this.getNBT().getAmount() + "")).replace("%rawname%", Enchants.getRawName(this.getNBT().getEnchantUPC())).replace("%name%", Enchants.getName(this.enchanter)).replace("%chance%", this.getNBT().getSuccess() + "").replace("%customname%", var2).replace("%fail%", 100 - this.getNBT().getSuccess() + "").replace("%tier%", this.getNBT().getTier()));
        meta.setLore(lore);
        if (Main.getInstance().getConfig().contains("Config.Enchanter." + this.tierName + ".CustomModelData")) {
            meta.setCustomModelData(Integer.valueOf(Main.getInstance().getConfig().getInt("Config.Enchanter." + this.tierName + ".CustomModelData")));
        }
        if (Main.getInstance().getConfig().getBoolean("Config.Enchanter." + this.tierName + ".Glow")) {
            meta.addEnchant(Enchantment.LOOT_BONUS_BLOCKS, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        this.enchanter.setItemMeta(meta);
        this.enchanter.setAmount(amount);
        if (p.getInventory().firstEmpty() == -1) {
            p.getWorld().dropItem(p.getLocation(), this.enchanter);
            return;
        }
        p.getInventory().addItem(new ItemStack[]{this.enchanter});
    }

    public void updateLore() {
        ItemMeta meta = this.enchanter.getItemMeta();
        List lore = Main.getInstance().getConfig().getStringList("Config.Enchanter." + this.tierName + ".Lore");
        int var1 = new EnchanterNBT(this.enchanter).getEnchantUPC();
        String var2 = Main.getInstance().getConfig().getString("Config.CustomNames." + var1);
        lore.replaceAll(s -> Utils.hexColor(s.replace("%amount%", this.getNBT().getAmount() + "")).replace("%rawname%", Enchants.getRawName(this.getNBT().getEnchantUPC())).replace("%name%", Enchants.getName(this.enchanter)).replace("%chance%", this.getNBT().getSuccess() + "").replace("%customname%", var2).replace("%fail%", 100 - this.getNBT().getSuccess() + "").replace("%tier%", this.getNBT().getTier()));
        assert (meta != null);
        meta.setLore(lore);
        this.enchanter.setItemMeta(meta);
    }

    public Enchanter setEnchant(String enchant) {
        NBTItem nbt = new NBTItem(this.enchanter);
        nbt.setString(nbtEnchant, enchant);
        nbt.applyNBT(this.enchanter);
        return this;
    }

    public Enchanter setEnchant(int enchant) {
        NBTItem nbt = new NBTItem(this.enchanter);
        nbt.setInteger(nbtEnchant, Integer.valueOf(enchant));
        nbt.applyNBT(this.enchanter);
        return this;
    }

    public Enchanter setAmount(int var1) {
        NBTItem nbt = new NBTItem(this.enchanter);
        nbt.setInteger(nbtAmount, Integer.valueOf(var1));
        nbt.applyNBT(this.enchanter);
        return this;
    }

    public Enchanter setSuccess(int var1) {
        NBTItem nbt = new NBTItem(this.enchanter);
        nbt.setInteger(nbtSuccess, Integer.valueOf(var1));
        nbt.applyNBT(this.enchanter);
        return this;
    }

    public Enchanter setTier(String var1) {
        NBTItem nbt = new NBTItem(this.enchanter);
        nbt.setString(nbtTier, var1);
        nbt.applyNBT(this.enchanter);
        return this;
    }

    public static boolean isEnchanter(ItemStack item) {
        NBTItem nbt = new NBTItem(item);
        return nbt.hasKey(nbtEnchant);
    }

    public static String getCustomTier() {
        return Main.getInstance().getConfig().getString("Config.TierGive");
    }

    public EnchanterNBT getNBT() {
        return new EnchanterNBT(this.enchanter);
    }
}

