/*
 * Decompiled with CFR 0.152.
 */
package com.frxnklxrd.enchanter.dust;

import com.frxnklxrd.enchanter.dust.DustConfig;
import com.frxnklxrd.enchanter.utilities.Utils;
import de.tr7zw.nbtapi.NBTItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Dust {
    private static final String nbtDustName = "enchanter-dust-name";
    private static final String nbtDust = "enchanter-dust";
    private final ItemStack dust;
    private final String dustName;

    public Dust(String var1) {
        this.dust = new ItemStack(Material.getMaterial((String)DustConfig.getConfig().getString("Dust." + var1 + ".Material")));
        this.dustName = var1;
    }

    public Dust(ItemStack item) {
        this.dust = item;
        this.dustName = this.getDustName();
    }

    public void createDust(Player p, int amount) {
        ItemMeta meta = this.dust.getItemMeta();
        String name = Utils.hexColor(DustConfig.getConfig().getString("Dust." + this.dustName + ".Name"));
        meta.setDisplayName(name);
        List lore = DustConfig.getConfig().getStringList("Dust." + this.dustName + ".Lore");
        lore.replaceAll(s -> Utils.hexColor(s.replace("%dust%", this.getAmount() + "")));
        meta.setLore(lore);
        this.dust.setItemMeta(meta);
        this.dust.setAmount(amount);
        NBTItem nbt = new NBTItem(this.dust);
        nbt.setString(nbtDustName, this.dustName);
        nbt.applyNBT(this.dust);
        p.getInventory().addItem(new ItemStack[]{this.dust});
    }

    public Dust setAmount(int amount) {
        NBTItem nbt = new NBTItem(this.dust);
        nbt.setInteger(nbtDust, Integer.valueOf(amount));
        nbt.applyNBT(this.dust);
        return this;
    }

    public int getAmount() {
        NBTItem nbt = new NBTItem(this.dust);
        return nbt.hasKey(nbtDust) != false ? nbt.getInteger(nbtDust) : 0;
    }

    public String getDustName() {
        NBTItem nbt = new NBTItem(this.dust);
        return nbt.hasKey(nbtDustName) != false ? nbt.getString(nbtDustName) : "None";
    }

    public List<String> getTiersList() {
        return new ArrayList<String>(DustConfig.getConfig().getStringList("Dust." + this.getDustName() + ".List-Tiers"));
    }

    public String getMode() {
        return DustConfig.getConfig().getString("Dust." + this.dustName + ".Mode");
    }

    public static boolean isDust(ItemStack item) {
        NBTItem nbt = new NBTItem(item);
        return nbt.hasKey(nbtDust);
    }
}

