/*
 * Decompiled with CFR 0.152.
 */
package com.frxnklxrd.enchanter;

import com.edwardbelt.edprison.EdPrison;
import com.frxnklxrd.enchanter.dust.DustConfig;
import com.frxnklxrd.enchanter.dust.DustEvent;
import com.frxnklxrd.enchanter.enchant.EnchantCmd;
import com.frxnklxrd.enchanter.enchant.events.EDPListener;
import com.frxnklxrd.enchanter.enchant.events.REVListener;
import com.frxnklxrd.enchanter.enchant.events.UPCListener;
import com.frxnklxrd.enchanter.mystery.MysteryConfig;
import com.frxnklxrd.enchanter.mystery.MysteryListener;
import com.frxnklxrd.enchanter.utilities.EnchanterTabCompleter;
import com.frxnklxrd.enchanter.utilities.UpdateNewVersion;
import com.frxnklxrd.enchanter.utilities.Utils;
import dev.drawethree.ultraprisoncore.UltraPrisonCore;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    private static Main instance;
    private static UltraPrisonCore core;
    private static EdPrison edprison;
    public String rutaConfig;

    public void onEnable() {
        instance = this;
        this.registerCommands();
        this.registerConfig();
        new MysteryConfig(this).registerConfig();
        new DustConfig(this).registerConfig();
        this.registerEvents();
        if (Bukkit.getPluginManager().getPlugin("UltraPrisonCore") != null) {
            core = UltraPrisonCore.getInstance();
            this.getServer().getPluginManager().registerEvents((Listener)new UPCListener(), (Plugin)this);
            this.getLogger().info(Utils.getColor("&cUltraPrisonCore just found."));
        } else if (Bukkit.getPluginManager().getPlugin("EdPrison") != null) {
            this.getServer().getPluginManager().registerEvents((Listener)new EDPListener(), (Plugin)this);
            this.getLogger().info(Utils.getColor("&cEdPrison just found."));
        } else if (Bukkit.getPluginManager().getPlugin("RevEnchants") != null) {
            this.getServer().getPluginManager().registerEvents((Listener)new REVListener(), (Plugin)this);
            this.getLogger().info(Utils.getColor("&cRevEnchants just found."));
        } else {
            this.getLogger().warning("Any dependencies is not found. Disable enchanter...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (Main.getInstance().getConfig().getBoolean("Config.NotifyForUpdates")) {
            new UpdateNewVersion().runTaskTimer((Plugin)this, 20L, 72000L);
        }
    }

    public void onDisable() {
    }

    public void registerCommands() {
        this.getCommand("enchanter").setExecutor((CommandExecutor)new EnchantCmd());
        this.getCommand("enchanter").setTabCompleter((TabCompleter)new EnchanterTabCompleter());
    }

    public void registerConfig() {
        File config = new File(this.getDataFolder(), "config.yml");
        this.rutaConfig = config.getPath();
        if (!config.exists()) {
            this.saveDefaultConfig();
        } else {
            this.reloadConfig();
        }
    }

    public static UltraPrisonCore getUltraPrisonCore() {
        return core;
    }

    public static EdPrison getEdPrison() {
        return edprison;
    }

    public static Main getInstance() {
        return instance;
    }

    public void registerEvents() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new MysteryListener(), (Plugin)this);
        pm.registerEvents((Listener)new DustEvent(), (Plugin)this);
    }
}

