/*
 * Decompiled with CFR 0.152.
 */
package me.GPSforLEGENDS.parachuteplus;

import events.PlayerInteract;
import events.PlayerJoin;
import events.PlayerMove;
import events.PlayerToggleFly;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import me.GPSforLEGENDS.parachuteplus.Metrics;
import me.GPSforLEGENDS.parachuteplus.Updater;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.CreatureType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class ParachutePlus
extends JavaPlugin {
    public ItemStack parachute;
    public ItemStack autoParachute;
    public boolean dobblespace;
    public boolean singleuse;
    public boolean damageParachute;
    private boolean useLeash;
    private boolean useRecipe;
    public boolean useAutoParachute;
    public boolean error = false;
    public int time;
    public int failchance;
    public int fallBlocks;
    public double fallspeed;
    public double speed;
    public Sound activatesound;
    public Sound disablesound;
    public Sound failsound;
    public List<String> playerparachute = new ArrayList<String>();
    public HashMap<String, Chicken> playerChicken = new HashMap();
    public HashMap<String, Block[]> playerBlocks = new HashMap();

    public void onEnable() {
        PluginManager pm = Bukkit.getPluginManager();
        pm.registerEvents((Listener)new PlayerMove(this), (Plugin)this);
        pm.registerEvents((Listener)new PlayerInteract(this), (Plugin)this);
        pm.registerEvents((Listener)new PlayerToggleFly(this), (Plugin)this);
        pm.registerEvents((Listener)new PlayerJoin(this), (Plugin)this);
        this.saveDefaultConfig();
        try {
            Metrics metrics = new Metrics((Plugin)this);
            metrics.start();
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.WARNING, "[Parachute] couldnt load Metrics");
        }
        Bukkit.getLogger().log(Level.INFO, "[Parachute] geting parachute infos from config");
        this.setupVar();
        this.ParachuteRecipe();
        this.update();
    }

    public void onDisable() {
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            if (cmd.getName().equalsIgnoreCase("Parachute") && p.hasPermission("Parachute.get")) {
                OfflinePlayer test;
                if (args.length == 0) {
                    p.getInventory().addItem(new ItemStack[]{this.parachute()});
                } else if (args.length == 1 && (test = this.getServer().getOfflinePlayer(args[0])).isOnline()) {
                    Player test2 = this.getServer().getPlayer(args[0]);
                    test2.getInventory().addItem(new ItemStack[]{this.parachute()});
                    sender.sendMessage("you give " + args[0] + " a parachute");
                    test2.sendMessage("received your parachute");
                }
            }
            if (cmd.getName().equalsIgnoreCase("Parachutereload") && p.hasPermission("Parachute.reload")) {
                this.saveConfig();
                this.reloadConfig();
                p.sendMessage("Parachute Reload complete");
            }
        }
        return true;
    }

    private ItemStack parachute() {
        int id = this.getConfig().getInt("Parachute.Item.id");
        String name = this.getConfig().getString("Parachute.Item.name");
        List lore = this.getConfig().getStringList("Parachute.Item.lore");
        ItemStack parachute = new ItemStack(id);
        ItemMeta meta = parachute.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(lore);
        parachute.setItemMeta(meta);
        return parachute;
    }

    private ItemStack autoParachute() {
        int id = this.getConfig().getInt("Parachute.autoParachute.id");
        String name = this.getConfig().getString("Parachute.autoParachute.name");
        List lore = this.getConfig().getStringList("Parachute.autoParachute.lore");
        ItemStack parachute = new ItemStack(id);
        ItemMeta meta = parachute.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(lore);
        parachute.setItemMeta(meta);
        return parachute;
    }

    private int time() {
        int time = this.getConfig().getInt("Parachute.time");
        if (time < 0) {
            time = -1;
        }
        return time;
    }

    private void setupVar() {
        try {
            this.parachute = this.parachute();
            this.autoParachute = this.autoParachute();
            this.dobblespace = this.getConfig().getBoolean("Parachute.dobblespace-to-activate");
            this.time = this.time();
            this.fallspeed = this.getConfig().getDouble("Parachute.fallspeed");
            this.speed = this.getConfig().getDouble("Parachute.speed");
            this.activatesound = Sound.valueOf((String)this.getConfig().getString("Parachute.activate_sound"));
            this.disablesound = Sound.valueOf((String)this.getConfig().getString("Parachute.disable_sound"));
            this.failsound = Sound.valueOf((String)this.getConfig().getString("Parachute.fail_sound"));
            this.failchance = this.getConfig().getInt("Parachute.failchance");
            this.singleuse = this.getConfig().getBoolean("Parachute.singleuse");
            this.damageParachute = this.getConfig().getBoolean("Parachute.remove-parachute-on-damage");
            this.useLeash = this.getConfig().getBoolean("Parachute.useLeash");
            this.useRecipe = this.getConfig().getBoolean("Parachute.Item.recipe.useRecipe");
            this.useAutoParachute = this.getConfig().getBoolean("Parachute.autoParachute.useAutoParachute");
            this.fallBlocks = this.getConfig().getInt("Parachute.autoParachute.fallBlocks");
        }
        catch (Exception e) {
            this.error = true;
            e.printStackTrace();
            Bukkit.getLogger().log(Level.WARNING, "couldnt load Parachute Infos from config. You may delete the old on and generate a new one");
        }
    }

    public void ParachuteRecipe() {
        if (this.useRecipe) {
            try {
                List rShape = this.getConfig().getList("Parachute.Item.recipe.shape");
                ShapedRecipe recipe = new ShapedRecipe(this.parachute);
                recipe.shape(new String[]{(String)rShape.get(0), (String)rShape.get(1), (String)rShape.get(2)});
                ArrayList<String> ichars = new ArrayList<String>();
                int i = 0;
                while (i <= 2) {
                    int i2 = 0;
                    while (i2 <= 2) {
                        char chr = ((String)rShape.get(i)).charAt(i2);
                        if (!ichars.contains(Character.valueOf(chr))) {
                            ichars.add(String.valueOf(chr));
                        }
                        ++i2;
                    }
                    ++i;
                }
                for (String str : ichars) {
                    if (str.equals(" ") || str == null) continue;
                    recipe.setIngredient(str.charAt(0), Material.valueOf((String)this.getConfig().getString("Parachute.Item.recipe.ingredients." + str)));
                }
                this.getServer().addRecipe((Recipe)recipe);
            }
            catch (Exception e) {
                e.printStackTrace();
                Bukkit.getLogger().log(Level.CONFIG, "[Parachute] Couldnt load parachute Recipe.");
                Bukkit.getLogger().log(Level.CONFIG, "[Parachute] If you changed recently from 1.1 to 1.2 you might delete the old config.");
                this.error = true;
            }
        }
    }

    private void update() {
        if (this.getConfig().getBoolean("Update")) {
            Updater updater = new Updater((Plugin)this, 88454, this.getFile(), Updater.UpdateType.NO_VERSION_CHECK, true);
        }
    }

    public void activateParachute(final Player p, ItemStack stack, boolean normalParachute) {
        if (!this.playerparachute.contains(p.getName())) {
            Random rnd;
            int zufall;
            if (this.singleuse) {
                int first;
                if (normalParachute) {
                    first = p.getInventory().first(this.parachute);
                    if (stack.getAmount() == 1) {
                        p.getInventory().remove(this.parachute);
                    } else {
                        stack.setAmount(stack.getAmount() - 1);
                        p.getInventory().setItem(first, stack);
                    }
                } else {
                    first = p.getInventory().first(stack);
                    if (stack.getAmount() == 1) {
                        p.getInventory().remove(stack);
                    } else {
                        stack.setAmount(stack.getAmount() - 1);
                        p.getInventory().setItem(first, stack);
                    }
                }
            }
            if ((zufall = (rnd = new Random()).nextInt(99) + 1) <= this.failchance) {
                p.playSound(p.getLocation(), this.failsound, 2.0f, 2.0f);
                return;
            }
            p.playSound(p.getLocation(), this.activatesound, 2.0f, 2.0f);
            this.playerparachute.add(p.getName());
            Chicken chick = (Chicken)p.getWorld().spawnCreature(p.getLocation(), CreatureType.CHICKEN);
            p.setPassenger((Entity)chick);
            if (this.useLeash) {
                chick.setLeashHolder((Entity)p);
            }
            this.playerChicken.put(p.getName(), chick);
            if (this.time >= 0) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

                    @Override
                    public void run() {
                        ParachutePlus.this.playerparachute.remove(p.getName());
                    }
                }, (long)(this.time * 20));
            }
        }
    }

    public void removeParachute(Player p) {
        this.playerparachute.remove(p.getName());
        p.playSound(p.getLocation(), this.disablesound, 2.0f, 2.0f);
        this.playerChicken.get(p.getName()).remove();
    }

    private void configStuff() {
        File cfg = new File(this.getDataFolder(), "config.yml");
        if (!cfg.exists()) {
            this.saveDefaultConfig();
        }
    }
}

