/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.utility;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.utility.FileHelper;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public final class UpdateChecker {
    private static final String APIResourceURL = "https://api.spigotmc.org/legacy/update.php?resource=97784";
    private static final String updateNotice = "A new update is available: %s (You are still on %s)";

    private UpdateChecker() {
    }

    public static void checkForUpdate() {
        BukkitScheduler scheduler = Stargate.getInstance().getServer().getScheduler();
        scheduler.runTaskAsynchronously((Plugin)Stargate.getInstance(), UpdateChecker::queryAPI);
    }

    private static void queryAPI() {
        try {
            InputStream inputStream = new URL(APIResourceURL).openStream();
            BufferedReader reader = FileHelper.getBufferedReaderFromInputStream(inputStream);
            String newVersion = reader.readLine();
            reader.close();
            String oldVersion = Stargate.getPluginVersion();
            if (UpdateChecker.isVersionHigher(oldVersion, newVersion)) {
                Stargate.getConsoleLogger().log(Level.INFO, Stargate.getBackupString("prefix") + UpdateChecker.getUpdateAvailableString(newVersion, oldVersion));
                Stargate.setUpdateAvailable(newVersion);
            }
        }
        catch (IOException e) {
            Stargate.debug("UpdateChecker", "Unable to get newest version.");
        }
    }

    public static String getUpdateAvailableString(String newVersion, String oldVersion) {
        return String.format(updateNotice, newVersion, oldVersion);
    }

    public static boolean isVersionHigher(String oldVersion, String newVersion) {
        String[] oldVersionParts = oldVersion.split("\\.");
        String[] newVersionParts = newVersion.split("\\.");
        int versionLength = Math.max(oldVersionParts.length, newVersionParts.length);
        for (int i = 0; i < versionLength; ++i) {
            int newVersionNumber;
            int oldVersionNumber = oldVersionParts.length > i ? Integer.parseInt(oldVersionParts[i]) : 0;
            int n = newVersionNumber = newVersionParts.length > i ? Integer.parseInt(newVersionParts[i]) : 0;
            if (newVersionNumber == oldVersionNumber) continue;
            return newVersionNumber > oldVersionNumber;
        }
        return false;
    }
}

