/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.utility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.PortalHandler;
import net.knarcraft.stargate.portal.PortalRegistry;
import net.knarcraft.stargate.portal.property.PortalOwner;
import net.knarcraft.stargate.utility.PortalFileHelper;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;

public final class UUIDMigrationHelper {
    private static Map<String, List<Portal>> playerNamesToMigrate;

    private UUIDMigrationHelper() {
    }

    public static void migrateUUID(OfflinePlayer player) {
        String playerName;
        Map<String, List<Portal>> playersToMigrate = UUIDMigrationHelper.getPlayersToMigrate();
        if (!playersToMigrate.containsKey(playerName = player.getName())) {
            return;
        }
        Stargate.debug("UUIDMigrationHelper::migrateUUID", String.format("Migrating name to UUID for player %s", playerName));
        List<Portal> portalsOwned = playersToMigrate.get(playerName);
        if (portalsOwned == null) {
            return;
        }
        UUIDMigrationHelper.migratePortalsToUUID(portalsOwned, player.getUniqueId());
        playersToMigrate.remove(playerName);
    }

    private static void migratePortalsToUUID(List<Portal> portals, UUID uniqueId) {
        HashSet<World> worldsToSave = new HashSet<World>();
        for (Portal portalCopy : portals) {
            Portal portal = PortalHandler.getByName(portalCopy.getCleanName(), portalCopy.getCleanNetwork());
            if (portal == null) continue;
            portal.getOwner().setUUID(uniqueId);
            worldsToSave.add(portal.getWorld());
        }
        for (World world : worldsToSave) {
            PortalFileHelper.saveAllPortals(world);
        }
    }

    private static Map<String, List<Portal>> getPlayersToMigrate() {
        if (playerNamesToMigrate != null) {
            return playerNamesToMigrate;
        }
        playerNamesToMigrate = new HashMap<String, List<Portal>>();
        for (Portal portal : PortalRegistry.getAllPortals()) {
            PortalOwner owner = portal.getOwner();
            String ownerName = owner.getName();
            if (owner.getUUID() != null) continue;
            List<Portal> portalList = playerNamesToMigrate.get(ownerName);
            if (portalList == null) {
                ArrayList<Portal> newList = new ArrayList<Portal>();
                newList.add(portal);
                playerNamesToMigrate.put(ownerName, newList);
                continue;
            }
            portalList.add(portal);
        }
        return playerNamesToMigrate;
    }
}

