/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.utility;

import java.util.ArrayList;
import java.util.List;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.teleporter.EntityTeleporter;
import net.knarcraft.stargate.utility.EconomyHelper;
import net.knarcraft.stargate.utility.PermissionHelper;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.util.Vector;

public final class TeleportHelper {
    private TeleportHelper() {
    }

    public static boolean noLeashedCreaturesPreventTeleportation(Player player) {
        List<Creature> nearbyCreatures = TeleportHelper.getLeashedCreatures(player);
        for (Creature creature : nearbyCreatures) {
            if (creature.getPassengers().isEmpty()) continue;
            return false;
        }
        if (Stargate.getGateConfig().handleLeashedCreatures()) {
            return true;
        }
        return nearbyCreatures.isEmpty();
    }

    public static List<Creature> getLeashedCreatures(Player player) {
        ArrayList<Creature> leashedCreatures = new ArrayList<Creature>();
        List nearbyEntities = player.getNearbyEntities(15.0, 15.0, 15.0);
        for (Entity entity : nearbyEntities) {
            Creature creature;
            if (!(entity instanceof Creature) || !(creature = (Creature)entity).isLeashed() || creature.getLeashHolder() != player) continue;
            leashedCreatures.add(creature);
        }
        return leashedCreatures;
    }

    public static void teleportAndAddPassenger(Entity targetVehicle, Entity passenger, Vector exitDirection, Vector newVelocity) {
        Location passengerExit = targetVehicle.getLocation().clone().setDirection(exitDirection);
        if (!passenger.teleport(passengerExit)) {
            Stargate.debug("TeleportHelper::handleVehiclePassengers", "Failed to teleport passenger" + passenger);
        } else {
            Stargate.debug("TeleportHelper::handleVehiclePassengers", "Teleported " + passenger + " to " + passengerExit);
        }
        if (!targetVehicle.addPassenger(passenger)) {
            Stargate.debug("TeleportHelper::handleVehiclePassengers", "Failed to add passenger" + passenger);
        } else {
            Stargate.debug("TeleportHelper::handleVehiclePassengers", "Added passenger " + passenger + " to " + targetVehicle);
        }
        Stargate.debug("VehicleTeleporter::teleportVehicle", "Setting velocity " + newVelocity + " for passenger " + passenger);
        passenger.setVelocity(newVelocity);
    }

    public static void handleEntityPassengers(List<Entity> passengers, Entity entity, Portal origin, Portal target, Vector exitRotation, Vector newVelocity) {
        for (Entity passenger : passengers) {
            List passengerPassengers = passenger.getPassengers();
            if (!passengerPassengers.isEmpty()) {
                Stargate.debug("Teleporter::handleEntityPassengers", "Found the entities: " + passengerPassengers + " as passengers of " + entity);
            }
            if (passenger.eject()) {
                TeleportHelper.handleEntityPassengers(passengerPassengers, passenger, origin, target, exitRotation, newVelocity);
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Stargate.getInstance(), () -> {
                if (passenger instanceof Player) {
                    Player player = (Player)passenger;
                    TeleportHelper.teleportLeashedCreatures(player, origin, target);
                }
                TeleportHelper.teleportAndAddPassenger(entity, passenger, exitRotation, newVelocity);
            }, passenger instanceof Player ? (long)Stargate.getGateConfig().waitForPlayerAfterTeleportDelay() : 0L);
        }
    }

    public static void teleportLeashedCreatures(Player player, Portal origin, Portal target) {
        if (!Stargate.getGateConfig().handleLeashedCreatures()) {
            return;
        }
        BukkitScheduler scheduler = Bukkit.getScheduler();
        List<Creature> nearbyEntities = TeleportHelper.getLeashedCreatures(player);
        for (Creature creature : nearbyEntities) {
            creature.setLeashHolder(null);
            scheduler.scheduleSyncDelayedTask((Plugin)Stargate.getInstance(), () -> {
                new EntityTeleporter(target, (Entity)creature).teleportEntity(origin);
                scheduler.scheduleSyncDelayedTask((Plugin)Stargate.getInstance(), () -> creature.setLeashHolder((Entity)player), (long)Stargate.getGateConfig().waitForPlayerAfterTeleportDelay());
            }, 2L);
        }
    }

    public static boolean containsNonPlayer(List<Entity> entities) {
        for (Entity entity : entities) {
            if (entity instanceof Player && !TeleportHelper.containsNonPlayer(entity.getPassengers())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsPlayer(List<Entity> entities) {
        for (Entity entity : entities) {
            if (!(entity instanceof Player) && !TeleportHelper.containsPlayer(entity.getPassengers())) continue;
            return true;
        }
        return false;
    }

    public static List<Player> getPlayers(List<Entity> entities) {
        ArrayList<Player> players = new ArrayList<Player>(5);
        for (Entity entity : entities) {
            if (entity instanceof Player) {
                players.add((Player)entity);
            }
            players.addAll(TeleportHelper.getPlayers(entity.getPassengers()));
        }
        return players;
    }

    public static boolean playerCanTeleport(Player player, Portal entrancePortal, Portal destinationPortal) {
        boolean canAffordFee;
        if (PermissionHelper.cannotAccessPortal(player, entrancePortal, destinationPortal)) {
            if (!entrancePortal.getOptions().isSilent()) {
                Stargate.getMessageSender().sendErrorMessage((CommandSender)player, Stargate.getString("denyMsg"));
            }
            entrancePortal.getPortalOpener().closePortal(false);
            return false;
        }
        int cost = EconomyHelper.getUseCost(player, entrancePortal, destinationPortal);
        boolean bl = canAffordFee = cost <= 0 || Stargate.getEconomyConfig().canAffordFee(player, cost);
        if (!canAffordFee) {
            if (!entrancePortal.getOptions().isSilent()) {
                Stargate.getMessageSender().sendErrorMessage((CommandSender)player, Stargate.getString("ecoInFunds"));
            }
            return false;
        }
        return TeleportHelper.noLeashedCreaturesPreventTeleportation(player);
    }
}

