/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.utility;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.container.BlockChangeRequest;
import net.knarcraft.stargate.container.BlockLocation;
import net.knarcraft.stargate.container.RelativeBlockVector;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.PortalHandler;
import net.knarcraft.stargate.portal.PortalRegistry;
import net.knarcraft.stargate.portal.PortalSignDrawer;
import net.knarcraft.stargate.portal.property.PortalLocation;
import net.knarcraft.stargate.portal.property.PortalOptions;
import net.knarcraft.stargate.portal.property.PortalOwner;
import net.knarcraft.stargate.portal.property.gate.Gate;
import net.knarcraft.stargate.portal.property.gate.GateHandler;
import net.knarcraft.stargate.utility.DirectionHelper;
import net.knarcraft.stargate.utility.MaterialHelper;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Waterlogged;

public final class PortalFileHelper {
    private PortalFileHelper() {
    }

    public static void saveAllPortals(World world) {
        Stargate.getStargateConfig().addManagedWorld(world.getName());
        String saveFileLocation = Stargate.getPortalFolder() + "/" + world.getName() + ".db";
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(saveFileLocation, false));
            for (Portal portal : PortalRegistry.getAllPortals()) {
                String worldName = portal.getWorld().getName();
                if (!worldName.equalsIgnoreCase(world.getName())) continue;
                PortalFileHelper.savePortal(bufferedWriter, portal);
            }
            bufferedWriter.close();
        }
        catch (Exception e) {
            Stargate.logSevere(String.format("Exception while writing stargates to %s: %s", saveFileLocation, e));
        }
    }

    private static void savePortal(BufferedWriter bufferedWriter, Portal portal) throws IOException {
        StringBuilder builder = new StringBuilder();
        BlockLocation button = portal.getStructure().getButton();
        builder.append(portal.getName()).append(':');
        builder.append(portal.getSignLocation().toString()).append(':');
        builder.append(button != null ? button.toString() : "").append(':');
        builder.append(0).append(':');
        builder.append(0).append(':');
        builder.append(portal.getYaw()).append(':');
        builder.append(portal.getTopLeft().toString()).append(':');
        builder.append(portal.getGate().getFilename()).append(':');
        builder.append(portal.getOptions().isFixed() ? portal.getDestinationName() : "").append(':');
        builder.append(portal.getNetwork()).append(':');
        builder.append(portal.getOwner().getIdentifier());
        PortalFileHelper.savePortalOptions(portal, builder);
        bufferedWriter.append(builder.toString());
        bufferedWriter.newLine();
    }

    private static void savePortalOptions(Portal portal, StringBuilder builder) {
        PortalOptions options = portal.getOptions();
        builder.append(':');
        builder.append(options.isHidden()).append(':');
        builder.append(options.isAlwaysOn()).append(':');
        builder.append(options.isPrivate()).append(':');
        builder.append(portal.getWorld().getName()).append(':');
        builder.append(options.isFree()).append(':');
        builder.append(options.isBackwards()).append(':');
        builder.append(options.isShown()).append(':');
        builder.append(options.isNoNetwork()).append(':');
        builder.append(options.isRandom()).append(':');
        builder.append(options.isBungee()).append(':');
        builder.append(options.isSilent()).append(':');
        builder.append(options.hasNoSign());
    }

    public static boolean loadAllPortals(World world) {
        String location = Stargate.getPortalFolder();
        File database = new File(location, world.getName() + ".db");
        if (database.exists()) {
            return PortalFileHelper.loadPortals(world, database);
        }
        Stargate.logInfo(String.format("{%s} No stargates for world ", world.getName()));
        return false;
    }

    private static boolean loadPortals(World world, File database) {
        int lineIndex = 0;
        try {
            Scanner scanner = new Scanner(database);
            boolean needsToSaveDatabase = false;
            while (scanner.hasNextLine()) {
                needsToSaveDatabase = PortalFileHelper.readPortalLine(scanner, ++lineIndex, world) || needsToSaveDatabase;
            }
            scanner.close();
            Stargate.debug("PortalFileHelper::loadPortals", String.format("Finished loading portals for %s. Starting post loading tasks", world));
            PortalFileHelper.doPostLoadTasks(world, needsToSaveDatabase);
            return true;
        }
        catch (Exception e) {
            Stargate.logSevere(String.format("Exception while reading stargates from %s: %d", database.getName(), lineIndex));
            e.printStackTrace();
            return false;
        }
    }

    private static boolean readPortalLine(Scanner scanner, int lineIndex, World world) {
        String line = scanner.nextLine().trim();
        if (line.startsWith("#") || line.isEmpty()) {
            return false;
        }
        String[] portalData = line.split(":");
        if (portalData.length < 8) {
            Stargate.logInfo(String.format("Invalid line - %s", lineIndex));
            return false;
        }
        return PortalFileHelper.loadPortal(portalData, world, lineIndex);
    }

    private static void doPostLoadTasks(World world, boolean needsToSaveDatabase) {
        PortalHandler.verifyAllPortals();
        int portalCount = PortalRegistry.getAllPortals().size();
        int openCount = PortalHandler.openAlwaysOpenPortals();
        Stargate.logInfo(String.format("{%s} Loaded %d stargates with %d set as always-on", world.getName(), portalCount, openCount));
        for (Portal portal : PortalRegistry.getAllPortals()) {
            if (!portal.isRegistered()) continue;
            portal.drawSign();
            PortalFileHelper.updatePortalButton(portal);
        }
        Stargate.debug("PortalFileHelper::doPostLoadTasks", String.format("Saving database for world %s", world));
        if (needsToSaveDatabase) {
            PortalFileHelper.saveAllPortals(world);
        }
    }

    private static boolean loadPortal(String[] portalData, World world, int lineIndex) {
        String name = portalData[0];
        BlockLocation button = portalData[2].length() > 0 ? new BlockLocation(world, portalData[2]) : null;
        PortalLocation portalLocation = new PortalLocation();
        portalLocation.setSignLocation(new BlockLocation(world, portalData[1]));
        portalLocation.setYaw(Float.parseFloat(portalData[5]));
        portalLocation.setTopLeft(new BlockLocation(world, portalData[6]));
        Gate gate = GateHandler.getGateByName(portalData[7]);
        if (gate == null) {
            PortalSignDrawer.markPortalWithInvalidGate(portalLocation, portalData[7], lineIndex);
            return false;
        }
        String destination = portalData.length > 8 ? portalData[8] : "";
        String network = portalData.length > 9 && !portalData[9].isEmpty() ? portalData[9] : Stargate.getDefaultNetwork();
        String ownerString = portalData.length > 10 ? portalData[10] : "";
        PortalOwner owner = new PortalOwner(ownerString);
        Portal portal = new Portal(portalLocation, button, destination, name, network, gate, owner, PortalHandler.getPortalOptions(portalData));
        boolean buttonLocationChanged = PortalFileHelper.updateButtonVector(portal);
        PortalHandler.registerPortal(portal);
        portal.getPortalOpener().closePortal(true);
        return buttonLocationChanged;
    }

    private static void updatePortalButton(Portal portal) {
        BlockLocation buttonLocation = PortalFileHelper.getButtonLocation(portal);
        if (portal.getOptions().isAlwaysOn()) {
            if (MaterialHelper.isButtonCompatible(buttonLocation.getType())) {
                Material newMaterial = PortalFileHelper.decideRemovalMaterial(buttonLocation, portal);
                Stargate.addBlockChangeRequest(new BlockChangeRequest(buttonLocation, newMaterial, null));
            }
        } else if (buttonLocation.getType() != portal.getGate().getPortalButton()) {
            PortalFileHelper.generatePortalButton(portal, DirectionHelper.getBlockFaceFromYaw(portal.getYaw()));
        }
    }

    public static Material decideRemovalMaterial(BlockLocation location, Portal portal) {
        Location leftLocation = location.getRelativeLocation(-1.0, 0.0, 0.0, portal.getYaw());
        Location rightLocation = location.getRelativeLocation(1.0, 0.0, 0.0, portal.getYaw());
        if (PortalFileHelper.isUnderwater(leftLocation) || PortalFileHelper.isUnderwater(rightLocation)) {
            return Material.WATER;
        }
        return Material.AIR;
    }

    private static boolean isUnderwater(Location location) {
        Waterlogged waterlogged;
        BlockData blockData = location.getBlock().getBlockData();
        return blockData.getMaterial() == Material.WATER || blockData instanceof Waterlogged && (waterlogged = (Waterlogged)blockData).isWaterlogged();
    }

    private static boolean updateButtonVector(Portal portal) {
        for (RelativeBlockVector control : portal.getGate().getLayout().getControls()) {
            BlockLocation controlLocation = portal.getLocation().getTopLeft().getRelativeLocation(control, portal.getYaw());
            BlockLocation buttonLocation = controlLocation.getRelativeLocation(new RelativeBlockVector(0, 0, 1), portal.getYaw());
            if (buttonLocation.equals((Object)portal.getLocation().getSignLocation())) continue;
            portal.getLocation().setButtonVector(control);
            BlockLocation oldButtonLocation = portal.getStructure().getButton();
            if (oldButtonLocation == null || oldButtonLocation.equals((Object)buttonLocation)) continue;
            Stargate.addBlockChangeRequest(new BlockChangeRequest(oldButtonLocation, Material.AIR, null));
            portal.getStructure().setButton(buttonLocation);
            return true;
        }
        return false;
    }

    public static void generatePortalButton(Portal portal, BlockFace buttonFacing) {
        BlockLocation button = PortalFileHelper.getButtonLocation(portal);
        Directional buttonData = (Directional)Bukkit.createBlockData((Material)portal.getGate().getPortalButton());
        buttonData.setFacing(buttonFacing);
        button.getBlock().setBlockData((BlockData)buttonData);
        portal.getStructure().setButton(button);
    }

    private static BlockLocation getButtonLocation(Portal portal) {
        BlockLocation topLeft = portal.getTopLeft();
        RelativeBlockVector buttonVector = portal.getLocation().getButtonVector();
        return topLeft.getRelativeLocation(buttonVector.addToVector(RelativeBlockVector.Property.OUT, 1), portal.getYaw());
    }
}

