/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.utility;

import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.event.StargateAccessEvent;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.property.PortalOption;
import net.knarcraft.stargate.portal.teleporter.PlayerTeleporter;
import net.knarcraft.stargate.utility.EconomyHelper;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerMoveEvent;

public final class PermissionHelper {
    private PermissionHelper() {
    }

    public static void openPortal(Player player, Portal portal) {
        Portal destination = portal.getPortalActivator().getDestination();
        if (portal.getOptions().isAlwaysOn()) {
            return;
        }
        if (destination == null || destination == portal) {
            if (!portal.getOptions().isSilent()) {
                Stargate.getMessageSender().sendErrorMessage((CommandSender)player, Stargate.getString("invalidMsg"));
            }
            return;
        }
        if (portal.isOpen()) {
            if (portal.getActivePlayer() == player) {
                portal.getPortalOpener().closePortal(false);
            }
            return;
        }
        if (!portal.getOptions().isFixed() && portal.getPortalActivator().isActive() && portal.getActivePlayer() != player) {
            if (!portal.getOptions().isSilent()) {
                Stargate.getMessageSender().sendErrorMessage((CommandSender)player, Stargate.getString("denyMsg"));
            }
            return;
        }
        if (portal.getOptions().isPrivate() && !PermissionHelper.canUsePrivatePortal(player, portal)) {
            if (!portal.getOptions().isSilent()) {
                Stargate.getMessageSender().sendErrorMessage((CommandSender)player, Stargate.getString("denyMsg"));
            }
            return;
        }
        if (destination.isOpen() && !destination.getOptions().isAlwaysOn()) {
            if (!portal.getOptions().isSilent()) {
                Stargate.getMessageSender().sendErrorMessage((CommandSender)player, Stargate.getString("blockMsg"));
            }
            return;
        }
        portal.getPortalOpener().openPortal(player, false);
    }

    public static boolean portalAccessDenied(Player player, Portal portal, boolean deny) {
        StargateAccessEvent event = new StargateAccessEvent(player, portal, deny);
        Stargate.getInstance().getServer().getPluginManager().callEvent((Event)event);
        return event.getDeny();
    }

    public static boolean cannotAccessPortal(Player player, Portal entrancePortal, Portal destination) {
        boolean deny = false;
        if (entrancePortal.getOptions().isBungee()) {
            if (!PermissionHelper.canAccessServer(player, entrancePortal.getCleanNetwork())) {
                Stargate.debug("cannotAccessPortal", "Cannot access server");
                deny = true;
            }
        } else if (PermissionHelper.cannotAccessNetwork(player, entrancePortal.getCleanNetwork())) {
            Stargate.debug("cannotAccessPortal", "Cannot access network");
            deny = true;
        } else if (PermissionHelper.cannotAccessWorld(player, destination.getWorld().getName())) {
            Stargate.debug("cannotAccessPortal", "Cannot access world");
            deny = true;
        }
        return PermissionHelper.portalAccessDenied(player, entrancePortal, deny);
    }

    public static boolean hasPermission(Player player, String permission) {
        if (Stargate.getStargateConfig().isPermissionDebuggingEnabled()) {
            Stargate.debug("hasPerm::Permission(" + player.getName() + ")", permission + " => " + player.hasPermission(permission));
        }
        return player.hasPermission(permission);
    }

    public static boolean hasPermissionImplicit(Player player, String permission) {
        if (!player.isPermissionSet(permission)) {
            if (Stargate.getStargateConfig().isPermissionDebuggingEnabled()) {
                Stargate.debug("hasPermissionImplicit::Permission", permission + " => implicitly true");
            }
            return true;
        }
        if (Stargate.getStargateConfig().isPermissionDebuggingEnabled()) {
            Stargate.debug("hasPermissionImplicit::Permission", permission + " => " + player.hasPermission(permission));
        }
        return player.hasPermission(permission);
    }

    public static boolean cannotAccessWorld(Player player, String world) {
        if (PermissionHelper.hasPermission(player, "stargate.world")) {
            return !PermissionHelper.hasPermissionImplicit(player, "stargate.world." + world);
        }
        return !PermissionHelper.hasPermission(player, "stargate.world." + world);
    }

    public static boolean cannotAccessNetwork(Player player, String network) {
        if (PermissionHelper.hasPermission(player, "stargate.network")) {
            return !PermissionHelper.hasPermissionImplicit(player, "stargate.network." + network);
        }
        if (PermissionHelper.hasPermission(player, "stargate.network." + network)) {
            return false;
        }
        String playerName = player.getName();
        if (playerName.length() > Stargate.getMaxNameNetworkLength()) {
            playerName = playerName.substring(0, Stargate.getMaxNameNetworkLength());
        }
        return !network.equals(playerName) || !PermissionHelper.hasPermission(player, "stargate.create.personal");
    }

    public static boolean canAccessServer(Player player, String server) {
        if (PermissionHelper.hasPermission(player, "stargate.server")) {
            return PermissionHelper.hasPermissionImplicit(player, "stargate.server." + server);
        }
        return PermissionHelper.hasPermission(player, "stargate.server." + server);
    }

    public static boolean isFree(Player player, Portal src, Portal dest) {
        if (src.getOptions().isFree()) {
            return true;
        }
        if (PermissionHelper.hasPermission(player, "stargate.free.use")) {
            return true;
        }
        return dest != null && Stargate.getEconomyConfig().freeIfFreeDestination() && dest.getOptions().isFree();
    }

    public static boolean canSeePortal(Player player, Portal portal) {
        if (!portal.getOptions().isHidden()) {
            return true;
        }
        if (PermissionHelper.hasPermission(player, "stargate.admin.hidden")) {
            return true;
        }
        return portal.isOwner(player);
    }

    public static boolean canUsePrivatePortal(Player player, Portal portal) {
        if (portal.isOwner(player)) {
            return true;
        }
        return PermissionHelper.hasPermission(player, "stargate.admin.private");
    }

    public static boolean canUseOption(Player player, PortalOption option) {
        return PermissionHelper.hasPermission(player, option.getPermissionString());
    }

    public static boolean canCreateNetworkGate(Player player, String network) {
        if (PermissionHelper.hasPermission(player, "stargate.create.network")) {
            return PermissionHelper.hasPermissionImplicit(player, "stargate.create.network." + network);
        }
        return PermissionHelper.hasPermission(player, "stargate.create.network." + network);
    }

    public static boolean canCreatePersonalPortal(Player player) {
        return PermissionHelper.hasPermission(player, "stargate.create.personal");
    }

    public static boolean canCreatePortal(Player player, String gate) {
        if (PermissionHelper.hasPermission(player, "stargate.create.gate")) {
            return PermissionHelper.hasPermissionImplicit(player, "stargate.create.gate." + gate);
        }
        return PermissionHelper.hasPermission(player, "stargate.create.gate." + gate);
    }

    public static boolean canDestroyPortal(Player player, Portal portal) {
        String network = portal.getCleanNetwork();
        if (portal.getOptions().isBungee()) {
            return PermissionHelper.hasPermission(player, "stargate.admin.bungee");
        }
        if (PermissionHelper.hasPermission(player, "stargate.destroy.network")) {
            return PermissionHelper.hasPermissionImplicit(player, "stargate.destroy.network." + network);
        }
        if (PermissionHelper.hasPermission(player, "stargate.destroy.network." + network)) {
            return true;
        }
        return portal.isOwner(player) && PermissionHelper.hasPermission(player, "stargate.destroy.personal");
    }

    public static boolean playerCannotTeleport(Portal entrancePortal, Portal destination, Player player, PlayerMoveEvent event) {
        if (entrancePortal == null || !entrancePortal.isOpen()) {
            return true;
        }
        if (!entrancePortal.getPortalOpener().isOpenFor(player)) {
            if (!entrancePortal.getOptions().isSilent()) {
                Stargate.getMessageSender().sendErrorMessage((CommandSender)player, Stargate.getString("denyMsg"));
            }
            new PlayerTeleporter(entrancePortal, player).teleportPlayer(entrancePortal, event);
            return true;
        }
        if (!entrancePortal.getOptions().isBungee() && destination == null) {
            return true;
        }
        if (PermissionHelper.cannotAccessPortal(player, entrancePortal, destination)) {
            if (!entrancePortal.getOptions().isSilent()) {
                Stargate.getMessageSender().sendErrorMessage((CommandSender)player, Stargate.getString("denyMsg"));
            }
            new PlayerTeleporter(entrancePortal, player).teleportPlayer(entrancePortal, event);
            entrancePortal.getPortalOpener().closePortal(false);
            return true;
        }
        int cost = EconomyHelper.getUseCost(player, entrancePortal, destination);
        if (cost > 0) {
            return EconomyHelper.cannotPayTeleportFee(entrancePortal, player, cost);
        }
        return false;
    }
}

