/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.utility;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import net.knarcraft.stargate.Stargate;
import org.bukkit.Material;

public final class GateReader {
    private GateReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int readGateFile(Scanner scanner, Map<Character, Material> characterMaterialMap, String fileName, List<List<Character>> design, Set<Material> frameTypes, Map<String, String> config) {
        boolean designing = false;
        int columns = 0;
        try {
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (designing) {
                    if ((columns = GateReader.readGateDesignLine(line, columns, characterMaterialMap, fileName, design)) >= 0) continue;
                    int n = -1;
                    return n;
                }
                if (!line.isEmpty() && !line.startsWith("#")) {
                    GateReader.readGateConfigValue(line, characterMaterialMap, frameTypes, config);
                    continue;
                }
                if (!line.isEmpty() && (line.contains("=") || line.startsWith("#"))) continue;
                designing = true;
            }
            return columns;
        }
        catch (Exception exception) {
            Stargate.logSevere(String.format("Could not load Gate %s - %s", fileName, exception.getMessage()));
            int n = -1;
            return n;
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    private static int readGateDesignLine(String line, int maxColumns, Map<Character, Material> characterMaterialMap, String fileName, List<List<Character>> design) {
        ArrayList<Character> row = new ArrayList<Character>();
        if (line.length() > maxColumns) {
            maxColumns = line.length();
        }
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character symbol = Character.valueOf(cArray[i]);
            if (symbol.equals(Character.valueOf('?')) || !characterMaterialMap.containsKey(symbol)) {
                Stargate.logSevere(String.format("Could not load Gate %s - Unknown symbol '%s' in diagram", fileName, symbol));
                return -1;
            }
            row.add(symbol);
        }
        design.add(row);
        return maxColumns;
    }

    private static void readGateConfigValue(String line, Map<Character, Material> characterMaterialMap, Set<Material> frameTypes, Map<String, String> config) throws Exception {
        String[] split = line.split("=");
        String key = split[0].trim();
        String value = split[1].trim();
        if (key.length() == 1) {
            Character symbol = Character.valueOf(key.charAt(0));
            Material material = Material.getMaterial((String)value);
            if (material == null) {
                throw new Exception("Invalid material in line: " + line);
            }
            characterMaterialMap.put(symbol, material);
            frameTypes.add(material);
        } else {
            config.put(key, value);
        }
    }

    public static int readGateConfig(Map<String, String> config, String fileName, String key) {
        if (config.containsKey(key)) {
            try {
                return Integer.parseInt(config.get(key));
            }
            catch (NumberFormatException ex) {
                Stargate.logWarning(String.format("%s reading %s: %s is not numeric", ex.getClass().getName(), fileName, key));
            }
        }
        return -1;
    }

    public static Material readGateConfig(Map<String, String> config, String fileName, String key, Material defaultMaterial) {
        if (config.containsKey(key)) {
            Material material = Material.getMaterial((String)config.get(key));
            if (material != null) {
                return material;
            }
            Stargate.logWarning(String.format("Error reading %s: %s is not a material", fileName, key));
        }
        return defaultMaterial;
    }

    public static Character[][] generateLayoutMatrix(List<List<Character>> design, int columns) {
        Character[][] layout = new Character[design.size()][columns];
        for (int lineIndex = 0; lineIndex < design.size(); ++lineIndex) {
            List<Character> row = design.get(lineIndex);
            Character[] result = new Character[columns];
            for (int rowIndex = 0; rowIndex < columns; ++rowIndex) {
                result[rowIndex] = rowIndex < row.size() ? row.get(rowIndex) : Character.valueOf(' ');
            }
            layout[lineIndex] = result;
        }
        return layout;
    }
}

