/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.utility;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;

public final class FileHelper {
    private FileHelper() {
    }

    public static InputStream getInputStreamForInternalFile(String file) {
        return FileHelper.class.getResourceAsStream(file);
    }

    public static BufferedReader getBufferedReaderFromString(String file) throws FileNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(file);
        return FileHelper.getBufferedReaderFromInputStream(fileInputStream);
    }

    public static BufferedReader getBufferedReaderFromInputStream(InputStream inputStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        return new BufferedReader(inputStreamReader);
    }

    public static BufferedWriter getBufferedWriterFromString(String file) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);
        return new BufferedWriter(outputStreamWriter);
    }

    public static Map<String, String> readKeyValuePairs(BufferedReader bufferedReader) throws IOException {
        HashMap<String, String> readPairs = new HashMap<String, String>();
        String line = bufferedReader.readLine();
        boolean firstLine = true;
        while (line != null) {
            int equalSignIndex;
            if (firstLine) {
                line = FileHelper.removeUTF8BOM(line);
                firstLine = false;
            }
            if ((equalSignIndex = line.indexOf(61)) == -1) {
                line = bufferedReader.readLine();
                continue;
            }
            String key = line.substring(0, equalSignIndex);
            String value = ChatColor.translateAlternateColorCodes((char)'&', (String)line.substring(equalSignIndex + 1));
            readPairs.put(key, value);
            line = bufferedReader.readLine();
        }
        bufferedReader.close();
        return readPairs;
    }

    private static String removeUTF8BOM(String string) {
        String UTF8_BOM = "\ufeff";
        if (string.startsWith(UTF8_BOM)) {
            string = string.substring(1);
        }
        return string;
    }
}

