/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.utility;

import java.util.UUID;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.config.EconomyConfig;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.property.PortalOwner;
import net.knarcraft.stargate.utility.PermissionHelper;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class EconomyHelper {
    private EconomyHelper() {
    }

    public static boolean cannotPayTeleportFee(Portal entrancePortal, Player player, int cost) {
        PortalOwner owner;
        Player portalOwner;
        boolean success;
        UUID ownerUUID = entrancePortal.getOwner().getUUID();
        if (ownerUUID == null) {
            Stargate.logWarning(String.format("The owner of the portal %s does not have a UUID and payment to owner was therefore not possible. Make the owner re-create the portal to fix this.", entrancePortal));
        }
        if (!(success = entrancePortal.getGate().getToOwner() != false && ownerUUID != null ? EconomyHelper.chargePlayerIfNecessary(player, ownerUUID, cost) : EconomyHelper.chargePlayerIfNecessary(player, cost))) {
            EconomyHelper.sendInsufficientFundsMessage(entrancePortal.getName(), player, cost);
            entrancePortal.getPortalOpener().closePortal(false);
            return true;
        }
        EconomyHelper.sendDeductMessage(entrancePortal.getName(), player, cost);
        if (entrancePortal.getGate().getToOwner().booleanValue() && (portalOwner = (owner = entrancePortal.getOwner()).getUUID() != null ? Stargate.getInstance().getServer().getPlayer(owner.getUUID()) : Stargate.getInstance().getServer().getPlayer(owner.getName())) != null) {
            EconomyHelper.sendObtainMessage(entrancePortal.getName(), portalOwner, cost);
        }
        return false;
    }

    public static void sendObtainMessage(String portalName, Player portalOwner, int earnings) {
        String obtainedMsg = Stargate.getString("ecoObtain");
        obtainedMsg = EconomyHelper.replaceVars(obtainedMsg, portalName, earnings);
        Stargate.getMessageSender().sendSuccessMessage((CommandSender)portalOwner, obtainedMsg);
    }

    public static void sendDeductMessage(String portalName, Player player, int cost) {
        String deductMsg = Stargate.getString("ecoDeduct");
        deductMsg = EconomyHelper.replaceVars(deductMsg, portalName, cost);
        Stargate.getMessageSender().sendSuccessMessage((CommandSender)player, deductMsg);
    }

    public static void sendInsufficientFundsMessage(String portalName, Player player, int cost) {
        String inFundMsg = Stargate.getString("ecoInFunds");
        inFundMsg = EconomyHelper.replaceVars(inFundMsg, portalName, cost);
        Stargate.getMessageSender().sendErrorMessage((CommandSender)player, inFundMsg);
    }

    public static void sendRefundMessage(String portalName, Player player, int cost) {
        String refundMsg = Stargate.getString("ecoRefund");
        refundMsg = EconomyHelper.replaceVars(refundMsg, portalName, -cost);
        Stargate.getMessageSender().sendSuccessMessage((CommandSender)player, refundMsg);
    }

    public static int getUseCost(Player player, Portal source, Portal destination) {
        EconomyConfig config = Stargate.getEconomyConfig();
        if (!config.useEconomy() || source.getOptions().isFree()) {
            return 0;
        }
        if (destination != null && config.freeIfFreeDestination() && destination.getOptions().isFree()) {
            return 0;
        }
        if (source.getGate().getToOwner().booleanValue() && source.isOwner(player)) {
            return 0;
        }
        if (PermissionHelper.hasPermission(player, "stargate.free.use")) {
            return 0;
        }
        return source.getGate().getUseCost();
    }

    public static boolean chargePlayerIfNecessary(Player player, UUID target, int cost) {
        if (EconomyHelper.skipPayment(cost)) {
            return true;
        }
        return EconomyHelper.chargePlayer(player, target, cost);
    }

    private static boolean chargePlayer(Player player, double amount) {
        Economy economy = Stargate.getEconomyConfig().getEconomy();
        if (Stargate.getEconomyConfig().isEconomyEnabled() && economy != null) {
            if (!economy.has((OfflinePlayer)player, amount)) {
                return false;
            }
            economy.withdrawPlayer((OfflinePlayer)player, amount);
        }
        return true;
    }

    public static boolean chargePlayerIfNecessary(Player player, int cost) {
        if (EconomyHelper.skipPayment(cost)) {
            return true;
        }
        return EconomyHelper.chargePlayer(player, cost);
    }

    private static boolean skipPayment(int cost) {
        return cost == 0 || !Stargate.getEconomyConfig().useEconomy();
    }

    private static boolean chargePlayer(Player player, UUID target, double amount) {
        Economy economy = Stargate.getEconomyConfig().getEconomy();
        if (Stargate.getEconomyConfig().isEconomyEnabled() && player.getUniqueId().compareTo(target) != 0 && economy != null) {
            if (!economy.has((OfflinePlayer)player, amount)) {
                return false;
            }
            economy.withdrawPlayer((OfflinePlayer)player, amount);
            economy.depositPlayer(Bukkit.getOfflinePlayer((UUID)target), amount);
        }
        return true;
    }

    private static String replaceVars(String message, String portalName, int cost) {
        return Stargate.replaceVars(message, new String[]{"%cost%", "%portal%"}, new String[]{Stargate.getEconomyConfig().format(cost), portalName});
    }
}

