/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.utility;

import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public final class DirectionHelper {
    private DirectionHelper() {
    }

    public static float getYawFromLocationDifference(Location location1, Location location2) {
        Location difference = location1.clone().subtract(location2.clone());
        if (difference.getX() > 0.0) {
            return 90.0f;
        }
        if (difference.getX() < 0.0) {
            return 270.0f;
        }
        if (difference.getZ() > 0.0) {
            return 180.0f;
        }
        if (difference.getZ() < 0.0) {
            return 0.0f;
        }
        throw new IllegalArgumentException("Locations given are equal or at the same x and y axis");
    }

    public static BlockFace getBlockFaceFromYaw(double yaw) {
        if ((yaw = DirectionHelper.normalizeYaw(yaw)) == 0.0) {
            return BlockFace.SOUTH;
        }
        if (yaw == 90.0) {
            return BlockFace.WEST;
        }
        if (yaw == 180.0) {
            return BlockFace.NORTH;
        }
        if (yaw == 270.0) {
            return BlockFace.EAST;
        }
        throw new IllegalArgumentException("Invalid yaw given. Yaw must be divisible by 90.");
    }

    public static Vector getDirectionVectorFromYaw(double yaw) {
        if ((yaw = DirectionHelper.normalizeYaw(yaw)) == 0.0) {
            return new Vector(0, 0, 1);
        }
        if (yaw == 90.0) {
            return new Vector(-1, 0, 0);
        }
        if (yaw == 180.0) {
            return new Vector(0, 0, -1);
        }
        if (yaw == 270.0) {
            return new Vector(1, 0, 0);
        }
        throw new IllegalArgumentException(String.format("Invalid yaw %f given", yaw));
    }

    public static Location moveLocation(Location location, double right, double down, double out, double yaw) {
        return location.add(DirectionHelper.getCoordinateVectorFromRelativeVector(right, down, out, yaw));
    }

    public static Vector getCoordinateVectorFromRelativeVector(double right, double down, double out, double yaw) {
        if (yaw == 0.0) {
            return new Vector(right, -down, out);
        }
        if (yaw == 90.0) {
            return new Vector(-out, -down, right);
        }
        if (yaw == 180.0) {
            return new Vector(-right, -down, -out);
        }
        if (yaw == 270.0) {
            return new Vector(out, -down, -right);
        }
        throw new IllegalArgumentException(String.format("Invalid yaw %f given", yaw));
    }

    private static double normalizeYaw(double yaw) {
        while (yaw < 0.0) {
            yaw += 360.0;
        }
        return yaw %= 360.0;
    }
}

