/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.utility;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.PortalHandler;
import net.knarcraft.stargate.portal.teleporter.PlayerTeleporter;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public final class BungeeHelper {
    private static final String bungeeSubChannel = "SGBungee";
    private static final String bungeeChannel = "BungeeCord";
    private static final String teleportMessageDelimiter = "#@#";
    private static final Map<UUID, String> bungeeQueue = new HashMap<UUID, String>();

    private BungeeHelper() {
    }

    public static String getBungeeChannel() {
        return bungeeChannel;
    }

    public static String removeFromQueue(UUID playerUUID) {
        return bungeeQueue.remove(playerUUID);
    }

    public static boolean sendTeleportationMessage(Player player, Portal entrancePortal) {
        try {
            String message = player.getUniqueId() + teleportMessageDelimiter + entrancePortal.getDestinationName();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF("Forward");
            dataOutputStream.writeUTF(BungeeHelper.stripColor(entrancePortal.getNetwork()));
            dataOutputStream.writeUTF(bungeeSubChannel);
            dataOutputStream.writeShort(message.length());
            dataOutputStream.writeBytes(message);
            player.sendPluginMessage((Plugin)Stargate.getInstance(), bungeeChannel, byteArrayOutputStream.toByteArray());
        }
        catch (IOException ex) {
            Stargate.logSevere("Error sending BungeeCord teleport packet");
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean changeServer(Player player, Portal entrancePortal) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF("Connect");
            dataOutputStream.writeUTF(BungeeHelper.stripColor(entrancePortal.getNetwork()));
            player.sendPluginMessage((Plugin)Stargate.getInstance(), bungeeChannel, byteArrayOutputStream.toByteArray());
        }
        catch (IOException ex) {
            Stargate.logSevere("Error sending BungeeCord connect packet");
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static String readPluginMessage(byte[] message) {
        byte[] data;
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(message));
            String subChannel = dataInputStream.readUTF();
            if (!subChannel.equals(bungeeSubChannel)) {
                return null;
            }
            short dataLength = dataInputStream.readShort();
            data = new byte[dataLength];
            dataInputStream.readFully(data);
        }
        catch (IOException ex) {
            Stargate.logSevere("Error receiving BungeeCord message");
            ex.printStackTrace();
            return null;
        }
        return new String(data);
    }

    public static void handleTeleportMessage(String receivedMessage) {
        String[] messageParts = receivedMessage.split(teleportMessageDelimiter);
        UUID playerUUID = UUID.fromString(messageParts[0]);
        String destination = messageParts[1];
        Player player = Stargate.getInstance().getServer().getPlayer(playerUUID);
        if (player == null) {
            bungeeQueue.put(playerUUID, destination);
        } else {
            Portal destinationPortal = PortalHandler.getBungeePortal(destination);
            if (destinationPortal == null) {
                Stargate.logInfo(String.format("Bungee portal %s does not exist", destination));
                return;
            }
            new PlayerTeleporter(destinationPortal, player).teleport(destinationPortal, null);
        }
    }

    public static boolean bungeeTeleport(Player player, Portal entrancePortal, PlayerMoveEvent event) {
        if (!Stargate.getGateConfig().enableBungee()) {
            if (!entrancePortal.getOptions().isSilent()) {
                Stargate.getMessageSender().sendErrorMessage((CommandSender)player, Stargate.getString("bungeeDisabled"));
            }
            entrancePortal.getPortalOpener().closePortal(false);
            return false;
        }
        new PlayerTeleporter(entrancePortal, player).teleportPlayer(entrancePortal, event);
        if (!BungeeHelper.sendTeleportationMessage(player, entrancePortal)) {
            Stargate.debug("bungeeTeleport", "Unable to send teleportation message");
            return false;
        }
        if (!BungeeHelper.changeServer(player, entrancePortal)) {
            Stargate.debug("bungeeTeleport", "Unable to change server");
            return false;
        }
        Stargate.debug("bungeeTeleport", "Teleported player to another server");
        return true;
    }

    private static String stripColor(String string) {
        return ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)string));
    }
}

