/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.thread;

import java.util.ArrayList;
import java.util.Queue;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.portal.Portal;

public class StarGateThread
implements Runnable {
    @Override
    public void run() {
        long time = System.currentTimeMillis() / 1000L;
        this.closeOpenPortals(time);
        this.deactivateActivePortals(time);
    }

    private void closeOpenPortals(long time) {
        ArrayList<Portal> closedPortals = new ArrayList<Portal>();
        Queue<Portal> openPortalsQueue = Stargate.getStargateConfig().getOpenPortalsQueue();
        for (Portal portal : openPortalsQueue) {
            if (portal.getOptions().isAlwaysOn() || !portal.isOpen() || time <= portal.getTriggeredTime() + (long)Stargate.getGateConfig().getOpenTime()) continue;
            portal.getPortalOpener().closePortal(false);
            closedPortals.add(portal);
        }
        openPortalsQueue.removeAll(closedPortals);
    }

    private void deactivateActivePortals(long time) {
        ArrayList<Portal> deactivatedPortals = new ArrayList<Portal>();
        Queue<Portal> activePortalsQueue = Stargate.getStargateConfig().getActivePortalsQueue();
        for (Portal portal : activePortalsQueue) {
            if (!portal.getPortalActivator().isActive() || time <= portal.getTriggeredTime() + (long)Stargate.getGateConfig().getActiveTime()) continue;
            portal.getPortalActivator().deactivate();
            deactivatedPortals.add(portal);
        }
        activePortalsQueue.removeAll(deactivatedPortals);
    }
}

