/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.thread;

import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.container.BlockChangeRequest;
import org.bukkit.Axis;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.EndGateway;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;

public class BlockChangeThread
implements Runnable {
    @Override
    public void run() {
        long sTime = System.nanoTime();
        while (System.nanoTime() - sTime < 25000000L && !BlockChangeThread.pollQueue()) {
        }
    }

    public static boolean pollQueue() {
        BlockChangeRequest blockChangeRequest = Stargate.getBlockChangeRequestQueue().poll();
        if (blockChangeRequest == null) {
            return true;
        }
        Block block = blockChangeRequest.getBlockLocation().getBlock();
        block.setType(blockChangeRequest.getMaterial(), false);
        if (blockChangeRequest.getMaterial() == Material.END_GATEWAY) {
            BlockChangeThread.fixEndGatewayGate(block);
        } else if (blockChangeRequest.getAxis() != null) {
            BlockChangeThread.orientBlock(block, blockChangeRequest.getAxis());
        }
        return false;
    }

    private static void fixEndGatewayGate(Block block) {
        EndGateway gateway = (EndGateway)block.getState();
        gateway.setAge(Long.MIN_VALUE);
        if (block.getWorld().getEnvironment() == World.Environment.THE_END) {
            gateway.setExitLocation(block.getLocation());
            gateway.setExactTeleport(true);
        }
        gateway.update(false, false);
    }

    private static void orientBlock(Block block, Axis axis) {
        Orientable orientable = (Orientable)block.getBlockData();
        orientable.setAxis(axis);
        block.setBlockData((BlockData)orientable);
    }
}

