/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.portal.teleporter;

import java.util.List;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.config.StargateGateConfig;
import net.knarcraft.stargate.event.StargateEntityPortalEvent;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.teleporter.EntityTeleporter;
import net.knarcraft.stargate.utility.DirectionHelper;
import net.knarcraft.stargate.utility.TeleportHelper;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class VehicleTeleporter
extends EntityTeleporter {
    private final Vehicle teleportingVehicle;

    public VehicleTeleporter(Portal targetPortal, Vehicle teleportingVehicle) {
        super(targetPortal, (Entity)teleportingVehicle);
        this.teleportingVehicle = teleportingVehicle;
    }

    @Override
    public boolean teleportEntity(Portal origin) {
        Stargate.debug("VehicleTeleporter::teleport", "Preparing to teleport: " + this.teleportingVehicle);
        double velocity = this.teleportingVehicle.getVelocity().length();
        this.teleportingVehicle.setVelocity(new Vector());
        Vector newVelocityDirection = DirectionHelper.getDirectionVectorFromYaw(this.portal.getYaw());
        Vector newVelocity = newVelocityDirection.multiply(velocity);
        this.exit = this.triggerPortalEvent(origin, new StargateEntityPortalEvent((Entity)this.teleportingVehicle, origin, this.portal, this.exit));
        if (this.exit == null) {
            return false;
        }
        return this.teleportVehicle(this.exit, newVelocity, origin);
    }

    private boolean teleportVehicle(Location exit, Vector newVelocity, Portal origin) {
        this.loadChunks();
        List passengers = this.teleportingVehicle.getPassengers();
        if (!passengers.isEmpty()) {
            if (!this.vehiclePassengersAllowed(passengers)) {
                return false;
            }
            if (!(this.teleportingVehicle instanceof LivingEntity) && Stargate.getGateConfig().enableCraftBookRemoveOnEjectFix()) {
                this.putPassengersInNewVehicle(passengers, exit, newVelocity, origin);
            } else {
                this.teleportVehicle(passengers, exit, newVelocity, origin);
            }
        } else {
            if (!Stargate.getGateConfig().handleEmptyVehicles()) {
                return false;
            }
            this.teleportingVehicle.teleport(exit);
            this.scheduler.scheduleSyncDelayedTask((Plugin)Stargate.getInstance(), () -> this.teleportingVehicle.setVelocity(newVelocity), 1L);
        }
        return true;
    }

    private boolean vehiclePassengersAllowed(List<Entity> passengers) {
        StargateGateConfig config = Stargate.getGateConfig();
        if (TeleportHelper.containsNonPlayer(passengers) && !config.handleCreatureTransportation()) {
            return false;
        }
        return TeleportHelper.containsPlayer(passengers) || config.handleNonPlayerVehicles();
    }

    private void teleportVehicle(List<Entity> passengers, Location exit, Vector newVelocity, Portal origin) {
        if (this.teleportingVehicle.eject()) {
            TeleportHelper.handleEntityPassengers(passengers, (Entity)this.teleportingVehicle, origin, this.portal, exit.getDirection(), newVelocity);
        }
        Stargate.debug("VehicleTeleporter::teleportVehicle", "Teleporting " + this.teleportingVehicle + " to final location " + exit + " with direction " + exit.getDirection());
        this.teleportingVehicle.teleport(exit, PlayerTeleportEvent.TeleportCause.PLUGIN);
        this.scheduler.scheduleSyncDelayedTask((Plugin)Stargate.getInstance(), () -> {
            Stargate.debug("VehicleTeleporter::teleportVehicle", "Setting velocity " + newVelocity + " for vehicle " + this.teleportingVehicle);
            this.teleportingVehicle.setVelocity(newVelocity);
        }, 1L);
    }

    private void putPassengersInNewVehicle(List<Entity> passengers, Location exit, Vector newVelocity, Portal origin) {
        World vehicleWorld = exit.getWorld();
        if (vehicleWorld == null) {
            Stargate.logWarning("Unable to get the world to teleport the vehicle to");
            return;
        }
        Vehicle newVehicle = (Vehicle)vehicleWorld.spawn(exit, this.teleportingVehicle.getClass());
        Vehicle vehicle = this.teleportingVehicle;
        if (vehicle instanceof Boat) {
            Boat boat = (Boat)vehicle;
            ((Boat)newVehicle).setWoodType(boat.getWoodType());
        }
        if (this.teleportingVehicle.eject()) {
            TeleportHelper.handleEntityPassengers(passengers, (Entity)newVehicle, origin, this.portal, exit.getDirection(), newVelocity);
        }
        this.teleportingVehicle.remove();
        this.scheduler.scheduleSyncDelayedTask((Plugin)Stargate.getInstance(), () -> newVehicle.setVelocity(newVelocity), 1L);
    }
}

