/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.portal.teleporter;

import java.util.ArrayList;
import java.util.List;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.container.BlockLocation;
import net.knarcraft.stargate.container.ChunkUnloadRequest;
import net.knarcraft.stargate.container.RelativeBlockVector;
import net.knarcraft.stargate.event.StargateTeleportEvent;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.teleporter.EntityTeleporter;
import net.knarcraft.stargate.utility.DirectionHelper;
import net.knarcraft.stargate.utility.EntityHelper;
import net.knarcraft.stargate.utility.TeleportHelper;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.util.Vector;

public abstract class Teleporter {
    protected final Portal portal;
    protected final BukkitScheduler scheduler;
    protected Location exit;
    protected final Entity teleportedEntity;

    public Teleporter(Portal portal, Entity teleportedEntity) {
        this.portal = portal;
        this.scheduler = Stargate.getInstance().getServer().getScheduler();
        this.teleportedEntity = teleportedEntity;
        this.exit = this.getExit(teleportedEntity);
    }

    public boolean teleport(Portal origin, StargateTeleportEvent stargateTeleportEvent) {
        List passengers = this.teleportedEntity.getPassengers();
        if (!origin.equals(this.portal)) {
            this.exit = this.triggerPortalEvent(origin, stargateTeleportEvent);
            if (this.exit == null) {
                return false;
            }
        }
        this.loadChunks();
        if (this.teleportedEntity.eject()) {
            TeleportHelper.handleEntityPassengers(passengers, this.teleportedEntity, origin, this.portal, this.exit.getDirection(), new Vector());
        }
        this.teleportedEntity.teleport(this.exit);
        return true;
    }

    public Location getExit() {
        return this.exit.clone();
    }

    protected Location triggerPortalEvent(Portal origin, StargateTeleportEvent stargateTeleportEvent) {
        Stargate.getInstance().getServer().getPluginManager().callEvent((Event)stargateTeleportEvent);
        if (stargateTeleportEvent.isCancelled()) {
            new EntityTeleporter(origin, this.teleportedEntity).teleportEntity(origin);
            return null;
        }
        return stargateTeleportEvent.getExit();
    }

    protected void adjustExitLocationRotation(Location exit) {
        int adjust = 0;
        if (this.portal.getOptions().isBackwards()) {
            adjust = 180;
        }
        float newYaw = (this.portal.getYaw() + (float)adjust) % 360.0f;
        Stargate.debug("Portal::adjustRotation", "Setting exit yaw to " + newYaw);
        exit.setDirection(DirectionHelper.getDirectionVectorFromYaw(newYaw));
    }

    protected void loadChunks() {
        for (Chunk chunk : this.getChunksToLoad()) {
            chunk.addPluginChunkTicket((Plugin)Stargate.getInstance());
            Stargate.addChunkUnloadRequest(new ChunkUnloadRequest(chunk, 10000L));
        }
    }

    private Location preventExitSuffocation(RelativeBlockVector relativeExit, Location exitLocation, Entity entity) {
        RelativeBlockVector openingLeft = this.getPortalExitEdge(relativeExit, -1);
        RelativeBlockVector openingRight = this.getPortalExitEdge(relativeExit, 1);
        int openingWidth = openingRight.getRight() - openingLeft.getRight() + 1;
        int existingOffset = relativeExit.getRight() - openingLeft.getRight();
        double newOffset = (double)(openingWidth - existingOffset) / 2.0;
        if (openingWidth > 1) {
            newOffset -= 0.5;
        }
        exitLocation = DirectionHelper.moveLocation(exitLocation, newOffset, 0.0, 0.0, this.portal.getYaw());
        return this.moveExitLocationOutwards(exitLocation, entity);
    }

    private Location moveExitLocationOutwards(Location exitLocation, Entity entity) {
        double entitySize = EntityHelper.getEntityMaxSize(entity);
        int entityBoxSize = EntityHelper.getEntityMaxSizeInt(entity);
        if (entitySize > 1.0) {
            double entityOffset = this.portal.getOptions().isAlwaysOn() ? (double)entityBoxSize / 2.0 : entitySize / 2.0 - 1.0;
            if (entity instanceof AbstractHorse) {
                entityOffset += 1.0;
            }
            exitLocation = DirectionHelper.moveLocation(exitLocation, 0.0, 0.0, entityOffset, this.portal.getYaw());
        }
        return exitLocation;
    }

    private RelativeBlockVector getPortalExitEdge(RelativeBlockVector relativeExit, int direction) {
        RelativeBlockVector openingEdge = relativeExit;
        while (true) {
            RelativeBlockVector possibleOpening = new RelativeBlockVector(openingEdge.getRight() + direction, openingEdge.getDown(), openingEdge.getOut());
            if (!this.portal.getGate().getLayout().getExits().contains(possibleOpening)) break;
            openingEdge = possibleOpening;
        }
        return openingEdge;
    }

    private Location adjustExitLocationHeight(Entity entity, Location exitLocation) {
        if (exitLocation != null) {
            Slab slab;
            Bisected bisected;
            BlockData blockData = exitLocation.getBlock().getBlockData();
            if (blockData instanceof Bisected && (bisected = (Bisected)blockData).getHalf() == Bisected.Half.BOTTOM || blockData instanceof Slab && (slab = (Slab)blockData).getType() == Slab.Type.BOTTOM || blockData.getMaterial() == Material.WATER) {
                Stargate.debug("adjustExitLocation", "Added a block to get above a slab or a block of water");
                exitLocation.add(0.0, 1.0, 0.0);
            }
            return exitLocation;
        }
        Stargate.logWarning("Unable to generate exit location");
        return entity.getLocation();
    }

    private Location getExit(Entity entity) {
        Location exitLocation = null;
        RelativeBlockVector relativeExit = this.portal.getGate().getLayout().getExit();
        if (relativeExit != null) {
            double entitySize;
            BlockLocation exit = this.portal.getBlockAt(relativeExit);
            float portalYaw = this.portal.getYaw();
            if (this.portal.getOptions().isBackwards()) {
                portalYaw += 180.0f;
            }
            exitLocation = exit.getRelativeLocation(0.0, 0.0, 1.0, portalYaw);
            if (entity != null && (entitySize = EntityHelper.getEntityMaxSize(entity)) > 1.0) {
                exitLocation = this.preventExitSuffocation(relativeExit, exitLocation, entity);
            }
        } else {
            Stargate.logWarning(String.format("Missing destination point in .gate file %s", this.portal.getGate().getFilename()));
        }
        Location adjusted = this.adjustExitLocationHeight(entity, exitLocation);
        this.adjustExitLocationRotation(adjusted);
        return adjusted;
    }

    private List<Chunk> getChunksToLoad() {
        ArrayList<Chunk> chunksToLoad = new ArrayList<Chunk>();
        for (RelativeBlockVector vector : this.portal.getGate().getLayout().getEntrances()) {
            int blockOffset;
            Location fiveBlocksForward;
            Chunk forwardChunk;
            BlockLocation entranceLocation = this.portal.getBlockAt(vector);
            Chunk chunk = entranceLocation.getChunk();
            if (!chunksToLoad.contains(chunk)) {
                chunksToLoad.add(chunk);
            }
            if (chunksToLoad.contains(forwardChunk = (fiveBlocksForward = DirectionHelper.moveLocation(entranceLocation, 0.0, 0.0, blockOffset = this.portal.getOptions().isBackwards() ? -5 : 5, this.portal.getYaw())).getChunk())) continue;
            chunksToLoad.add(forwardChunk);
        }
        return chunksToLoad;
    }
}

