/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.portal.teleporter;

import java.util.List;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.event.StargatePlayerPortalEvent;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.teleporter.Teleporter;
import net.knarcraft.stargate.utility.DirectionHelper;
import net.knarcraft.stargate.utility.TeleportHelper;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class PlayerTeleporter
extends Teleporter {
    private final Player player;

    public PlayerTeleporter(Portal targetPortal, Player player) {
        super(targetPortal, (Entity)player);
        this.player = player;
    }

    public void teleportPlayer(Portal origin, PlayerMoveEvent event) {
        double velocity = this.player.getVelocity().length();
        List passengers = this.player.getPassengers();
        if (!origin.equals(this.portal)) {
            this.exit = this.triggerPortalEvent(origin, new StargatePlayerPortalEvent(this.player, origin, this.portal, this.exit));
            if (this.exit == null) {
                return;
            }
        }
        Vector newVelocityDirection = DirectionHelper.getDirectionVectorFromYaw(this.portal.getYaw());
        Vector newVelocity = newVelocityDirection.multiply(velocity * Stargate.getGateConfig().getExitVelocity());
        this.loadChunks();
        TeleportHelper.teleportLeashedCreatures(this.player, origin, this.portal);
        if (this.player.eject()) {
            TeleportHelper.handleEntityPassengers(passengers, (Entity)this.player, origin, this.portal, this.exit.getDirection(), newVelocity);
        }
        if (event == null) {
            this.player.teleport(this.exit);
        } else {
            event.setTo(this.exit);
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Stargate.getInstance(), () -> this.player.setVelocity(newVelocity), 1L);
    }
}

