/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.portal.property.gate;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.knarcraft.stargate.container.RelativeBlockVector;
import net.knarcraft.stargate.portal.property.gate.GateHandler;

public class GateLayout {
    private final Character[][] layout;
    private final List<RelativeBlockVector> exits = new ArrayList<RelativeBlockVector>();
    private RelativeBlockVector[] entrances = new RelativeBlockVector[0];
    private RelativeBlockVector[] border = new RelativeBlockVector[0];
    private RelativeBlockVector[] controls = new RelativeBlockVector[0];
    private RelativeBlockVector exitBlock = null;

    public GateLayout(Character[][] layout) {
        this.layout = layout;
        this.readLayout();
    }

    public Character[][] getLayout() {
        return this.layout;
    }

    public RelativeBlockVector[] getEntrances() {
        return this.entrances;
    }

    public RelativeBlockVector[] getBorder() {
        return this.border;
    }

    public RelativeBlockVector getExit() {
        return this.exitBlock;
    }

    public List<RelativeBlockVector> getExits() {
        return this.exits;
    }

    public RelativeBlockVector[] getControls() {
        return this.controls;
    }

    public void saveLayout(BufferedWriter bufferedWriter) throws IOException {
        Character[][] characterArray = this.layout;
        int n = characterArray.length;
        for (int i = 0; i < n; ++i) {
            Character[] line;
            for (Character character : line = characterArray[i]) {
                bufferedWriter.append(character.charValue());
            }
            bufferedWriter.newLine();
        }
    }

    private void readLayout() {
        ArrayList<RelativeBlockVector> entranceList = new ArrayList<RelativeBlockVector>();
        ArrayList<RelativeBlockVector> borderList = new ArrayList<RelativeBlockVector>();
        ArrayList<RelativeBlockVector> controlList = new ArrayList<RelativeBlockVector>();
        this.readLayout(controlList, entranceList, borderList);
        this.entrances = entranceList.toArray(this.entrances);
        this.border = borderList.toArray(this.border);
        this.controls = controlList.toArray(this.controls);
    }

    private void readLayout(List<RelativeBlockVector> controlList, List<RelativeBlockVector> entranceList, List<RelativeBlockVector> borderList) {
        int[] exitDepths = new int[this.layout[0].length];
        int lineCount = this.layout.length;
        for (int rowIndex = 0; rowIndex < lineCount; ++rowIndex) {
            Character[] row = this.layout[rowIndex];
            int rowSize = row.length;
            for (int columnIndex = 0; columnIndex < rowSize; ++columnIndex) {
                Character key = row[columnIndex];
                this.parseLayoutCharacter(key, columnIndex, rowIndex, exitDepths, controlList, entranceList, borderList);
            }
        }
        for (int x = 0; x < exitDepths.length; ++x) {
            if (exitDepths[x] <= 0) continue;
            this.exits.add(new RelativeBlockVector(x, exitDepths[x], 0));
        }
    }

    private void parseLayoutCharacter(Character key, int columnIndex, int rowIndex, int[] exitDepths, List<RelativeBlockVector> controlList, List<RelativeBlockVector> entranceList, List<RelativeBlockVector> borderList) {
        if (key.equals(GateHandler.getControlBlockCharacter())) {
            controlList.add(new RelativeBlockVector(columnIndex, rowIndex, 0));
        }
        if (this.isOpening(key)) {
            entranceList.add(new RelativeBlockVector(columnIndex, rowIndex, 0));
            exitDepths[columnIndex] = rowIndex;
            if (key.equals(GateHandler.getExitCharacter())) {
                this.exitBlock = new RelativeBlockVector(columnIndex, rowIndex, 0);
            }
        } else if (!key.equals(GateHandler.getAnythingCharacter())) {
            borderList.add(new RelativeBlockVector(columnIndex, rowIndex, 0));
        }
    }

    private boolean isOpening(Character character) {
        return character.equals(GateHandler.getEntranceCharacter()) || character.equals(GateHandler.getExitCharacter());
    }
}

