/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.portal.property.gate;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.portal.property.gate.Gate;
import net.knarcraft.stargate.portal.property.gate.GateLayout;
import net.knarcraft.stargate.utility.GateReader;
import net.knarcraft.stargate.utility.MaterialHelper;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class GateHandler {
    private static final Character ANYTHING = Character.valueOf(' ');
    private static final Character ENTRANCE = Character.valueOf('.');
    private static final Character EXIT = Character.valueOf('*');
    private static final Character CONTROL_BLOCK = Character.valueOf('-');
    private static final Material defaultPortalBlockOpen = Material.NETHER_PORTAL;
    private static final Material defaultPortalBlockClosed = Material.AIR;
    private static final Material defaultButton = Material.STONE_BUTTON;
    private static final HashMap<String, Gate> gates = new HashMap();
    private static final HashMap<Material, List<Gate>> controlBlocks = new HashMap();

    private GateHandler() {
    }

    public static Character getAnythingCharacter() {
        return ANYTHING;
    }

    public static Character getEntranceCharacter() {
        return ENTRANCE;
    }

    public static Character getExitCharacter() {
        return EXIT;
    }

    public static Character getControlBlockCharacter() {
        return CONTROL_BLOCK;
    }

    private static void registerGate(Gate gate) {
        gates.put(gate.getFilename(), gate);
        Material blockID = gate.getControlBlock();
        if (!controlBlocks.containsKey(blockID)) {
            controlBlocks.put(blockID, new ArrayList());
        }
        controlBlocks.get(blockID).add(gate);
    }

    private static Gate loadGate(File file) {
        Scanner scanner = new Scanner(file);
        try {
            Gate gate = GateHandler.loadGate(file.getName(), file.getParent(), scanner);
            scanner.close();
            return gate;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                Stargate.logSevere(String.format("Could not load Gate %s - %s", file.getName(), exception.getMessage()));
                return null;
            }
        }
    }

    private static Gate loadGate(String fileName, String parentFolder, Scanner scanner) {
        ArrayList<List<Character>> design = new ArrayList<List<Character>>();
        HashMap<Character, Material> characterMaterialMap = new HashMap<Character, Material>();
        HashMap<String, String> config = new HashMap<String, String>();
        HashSet<Material> frameTypes = new HashSet<Material>();
        characterMaterialMap.put(ENTRANCE, Material.AIR);
        characterMaterialMap.put(EXIT, Material.AIR);
        characterMaterialMap.put(ANYTHING, Material.AIR);
        int columns = GateReader.readGateFile(scanner, characterMaterialMap, fileName, design, frameTypes, config);
        if (columns < 0) {
            return null;
        }
        Character[][] layout = GateReader.generateLayoutMatrix(design, columns);
        Gate gate = GateHandler.createGate(config, fileName, layout, characterMaterialMap);
        if (gate == null) {
            return null;
        }
        gate.save(parentFolder + "/");
        return gate;
    }

    private static Gate createGate(Map<String, String> config, String fileName, Character[][] layout, Map<Character, Material> characterMaterialMap) {
        boolean toOwner;
        int destroyCost;
        int createCost;
        int useCost;
        Material portalButton;
        Material portalClosedBlock;
        Material portalOpenBlock = GateReader.readGateConfig(config, fileName, "portal-open", defaultPortalBlockOpen);
        Gate gate = new Gate(fileName, new GateLayout(layout), characterMaterialMap, portalOpenBlock, portalClosedBlock = GateReader.readGateConfig(config, fileName, "portal-closed", defaultPortalBlockClosed), portalButton = GateReader.readGateConfig(config, fileName, "button", defaultButton), useCost = GateReader.readGateConfig(config, fileName, "usecost"), createCost = GateReader.readGateConfig(config, fileName, "createcost"), destroyCost = GateReader.readGateConfig(config, fileName, "destroycost"), toOwner = config.containsKey("toowner") ? Boolean.parseBoolean(config.get("toowner")) : Stargate.getEconomyConfig().sendPaymentToOwner());
        if (!GateHandler.validateGate(gate, fileName)) {
            return null;
        }
        return gate;
    }

    private static boolean validateGate(Gate gate, String fileName) {
        String failString = String.format("Could not load Gate %s", fileName) + " - %s";
        if (gate.getLayout().getControls().length != 2) {
            Stargate.logSevere(String.format(failString, "Gates must have exactly 2 control points."));
            return false;
        }
        if (!MaterialHelper.isButtonCompatible(gate.getPortalButton())) {
            Stargate.logSevere(String.format(failString, "Gate button must be a type of button."));
            return false;
        }
        if (!gate.getPortalOpenBlock().isBlock()) {
            Stargate.logSevere(String.format(failString, "Gate open block must be a type of block."));
            return false;
        }
        if (!gate.getPortalClosedBlock().isBlock()) {
            Stargate.logSevere(String.format(failString, "Gate closed block must be a type of block."));
            return false;
        }
        for (Material material : gate.getCharacterMaterialMap().values()) {
            if (material.isBlock()) continue;
            Stargate.logSevere(String.format(failString, "Every gate border block must be a type of block."));
            return false;
        }
        return true;
    }

    public static void loadGates(String gateFolder) {
        File directory = new File(gateFolder);
        File[] files = directory.exists() ? directory.listFiles(file -> file.isFile() && file.getName().endsWith(".gate")) : new File[]{};
        if (files == null || files.length == 0) {
            if (directory.mkdir()) {
                GateHandler.writeDefaultGatesToFolder(gateFolder);
            }
        } else {
            for (File file2 : files) {
                Gate gate = GateHandler.loadGate(file2);
                if (gate == null) continue;
                GateHandler.registerGate(gate);
            }
        }
    }

    public static void writeDefaultGatesToFolder(String gateFolder) {
        GateHandler.loadGateFromJar("nethergate.gate", gateFolder);
        GateHandler.loadGateFromJar("watergate.gate", gateFolder);
        GateHandler.loadGateFromJar("endgate.gate", gateFolder);
        GateHandler.loadGateFromJar("squarenetherglowstonegate.gate", gateFolder);
    }

    private static void loadGateFromJar(String gateFile, String gateFolder) {
        Scanner scanner;
        Gate gate;
        InputStream gateFileStream = Gate.class.getResourceAsStream("/gates/" + gateFile);
        if (gateFileStream != null && (gate = GateHandler.loadGate(gateFile, gateFolder, scanner = new Scanner(gateFileStream))) != null) {
            GateHandler.registerGate(gate);
        }
    }

    public static Gate[] getGatesByControlBlock(Block block) {
        return GateHandler.getGatesByControlBlock(block.getType());
    }

    public static Gate[] getGatesByControlBlock(Material type) {
        Gate[] result = new Gate[]{};
        List<Gate> lookup = controlBlocks.get(type);
        if (lookup != null) {
            result = lookup.toArray(result);
        }
        return result;
    }

    public static Gate getGateByName(String fileName) {
        return gates.get(fileName);
    }

    public static int getGateCount() {
        return gates.size();
    }

    public static void clearGates() {
        gates.clear();
        controlBlocks.clear();
    }
}

