/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.portal.property.gate;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.container.BlockLocation;
import net.knarcraft.stargate.container.RelativeBlockVector;
import net.knarcraft.stargate.portal.property.gate.GateHandler;
import net.knarcraft.stargate.portal.property.gate.GateLayout;
import org.bukkit.Material;

public class Gate {
    private final String filename;
    private final GateLayout layout;
    private final Map<Character, Material> characterMaterialMap;
    private final Material portalOpenBlock;
    private final Material portalClosedBlock;
    private final Material portalButton;
    private final int useCost;
    private final int createCost;
    private final int destroyCost;
    private final boolean toOwner;

    public Gate(String filename, GateLayout layout, Map<Character, Material> characterMaterialMap, Material portalOpenBlock, Material portalClosedBlock, Material portalButton, int useCost, int createCost, int destroyCost, boolean toOwner) {
        this.filename = filename;
        this.layout = layout;
        this.characterMaterialMap = characterMaterialMap;
        this.portalOpenBlock = portalOpenBlock;
        this.portalClosedBlock = portalClosedBlock;
        this.portalButton = portalButton;
        this.useCost = useCost;
        this.createCost = createCost;
        this.destroyCost = destroyCost;
        this.toOwner = toOwner;
    }

    public GateLayout getLayout() {
        return this.layout;
    }

    public Map<Character, Material> getCharacterMaterialMap() {
        return new HashMap<Character, Material>(this.characterMaterialMap);
    }

    public Material getControlBlock() {
        return this.characterMaterialMap.get(GateHandler.getControlBlockCharacter());
    }

    public String getFilename() {
        return this.filename;
    }

    public Material getPortalOpenBlock() {
        return this.portalOpenBlock;
    }

    public Material getPortalClosedBlock() {
        return this.portalClosedBlock;
    }

    public Material getPortalButton() {
        return this.portalButton;
    }

    public int getUseCost() {
        return this.useCost < 0 ? Stargate.getEconomyConfig().getDefaultUseCost() : this.useCost;
    }

    public Integer getCreateCost() {
        return this.createCost < 0 ? Stargate.getEconomyConfig().getDefaultCreateCost() : this.createCost;
    }

    public Integer getDestroyCost() {
        return this.destroyCost < 0 ? Stargate.getEconomyConfig().getDefaultDestroyCost() : this.destroyCost;
    }

    public Boolean getToOwner() {
        return this.toOwner;
    }

    public boolean matches(BlockLocation topLeft, double yaw) {
        return this.matches(topLeft, yaw, false);
    }

    public boolean matches(BlockLocation topLeft, double yaw, boolean onCreate) {
        return this.verifyGateEntrancesMatch(topLeft, yaw, onCreate) && this.verifyGateBorderMatches(topLeft, yaw);
    }

    private boolean verifyGateBorderMatches(BlockLocation topLeft, double yaw) {
        HashMap<Character, Material> characterMaterialMap = new HashMap<Character, Material>(this.characterMaterialMap);
        for (RelativeBlockVector borderVector : this.layout.getBorder()) {
            int rowIndex = borderVector.getRight();
            int lineIndex = borderVector.getDown();
            Character key = this.layout.getLayout()[lineIndex][rowIndex];
            Material materialInLayout = (Material)characterMaterialMap.get(key);
            Material materialAtLocation = topLeft.getRelativeLocation(borderVector, yaw).getType();
            if (materialInLayout == null) {
                characterMaterialMap.put(key, materialAtLocation);
                Stargate.debug("Gate::Matches", String.format("Missing layout material in %s. Using %s from the physical portal.", this.getFilename(), materialAtLocation));
                continue;
            }
            if (materialAtLocation == materialInLayout) continue;
            Stargate.debug("Gate::Matches", String.format("Block Type Mismatch: %s != %s", materialAtLocation, materialInLayout));
            return false;
        }
        return true;
    }

    private boolean verifyGateEntrancesMatch(BlockLocation topLeft, double yaw, boolean onCreate) {
        Stargate.debug("verifyGateEntrancesMatch", String.valueOf((Object)topLeft));
        for (RelativeBlockVector entranceVector : this.layout.getEntrances()) {
            Stargate.debug("verifyGateEntrancesMatch", String.valueOf(entranceVector));
            Material type = topLeft.getRelativeLocation(entranceVector, yaw).getType();
            if (onCreate && (type.isAir() || type == Material.WATER) || type == this.portalClosedBlock || type == this.portalOpenBlock) continue;
            Stargate.debug("Gate::Matches", "Entrance/Exit Material Mismatch: " + type);
            return false;
        }
        return true;
    }

    public void save(String gateFolder) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(gateFolder + this.filename));
            this.writeConfig(bufferedWriter, "portal-open", this.portalOpenBlock.name());
            this.writeConfig(bufferedWriter, "portal-closed", this.portalClosedBlock.name());
            this.writeConfig(bufferedWriter, "button", this.portalButton.name());
            this.saveEconomyValues(bufferedWriter);
            this.saveFrameBlockTypes(bufferedWriter);
            bufferedWriter.newLine();
            this.layout.saveLayout(bufferedWriter);
            bufferedWriter.close();
        }
        catch (IOException ex) {
            Stargate.logSevere(String.format("Could not save Gate %s - %s", this.filename, ex.getMessage()));
        }
    }

    private void saveEconomyValues(BufferedWriter bufferedWriter) throws IOException {
        if (this.useCost != -1) {
            this.writeConfig(bufferedWriter, "usecost", this.useCost);
        }
        if (this.createCost != -1) {
            this.writeConfig(bufferedWriter, "createcost", this.createCost);
        }
        if (this.destroyCost != -1) {
            this.writeConfig(bufferedWriter, "destroycost", this.destroyCost);
        }
        this.writeConfig(bufferedWriter, "toowner", this.toOwner);
    }

    private void saveFrameBlockTypes(BufferedWriter bufferedWriter) throws IOException {
        for (Map.Entry<Character, Material> entry : this.characterMaterialMap.entrySet()) {
            Character type = entry.getKey();
            Material value = entry.getValue();
            if (type.equals(GateHandler.getAnythingCharacter()) || type.equals(GateHandler.getEntranceCharacter()) || type.equals(GateHandler.getExitCharacter())) continue;
            bufferedWriter.append(type.charValue());
            bufferedWriter.append('=');
            if (value != null) {
                bufferedWriter.append(value.toString());
            }
            bufferedWriter.newLine();
        }
    }

    private void writeConfig(BufferedWriter bufferedWriter, String key, Object value) throws IOException {
        Object format = "%s=";
        if (value instanceof Boolean) {
            format = (String)format + "%b";
        } else if (value instanceof Integer) {
            format = (String)format + "%d";
        } else if (value instanceof String) {
            format = (String)format + "%s";
        } else {
            throw new IllegalArgumentException("Unrecognized config value type");
        }
        bufferedWriter.append(String.format((String)format, key, value));
        bufferedWriter.newLine();
    }
}

