/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.portal.property;

import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.container.BlockLocation;
import net.knarcraft.stargate.container.RelativeBlockVector;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.property.gate.Gate;

public class PortalStructure {
    private final Portal portal;
    private final Gate gate;
    private BlockLocation button;
    private BlockLocation[] frame;
    private BlockLocation[] entrances;
    private boolean verified;

    public PortalStructure(Portal portal, Gate gate, BlockLocation button) {
        this.portal = portal;
        this.gate = gate;
        this.verified = false;
        this.button = button;
    }

    public Gate getGate() {
        return this.gate;
    }

    public BlockLocation getButton() {
        return this.button;
    }

    public void setButton(BlockLocation button) {
        this.button = button;
    }

    public boolean isVerified() {
        boolean verified = true;
        if (!Stargate.getGateConfig().verifyPortals()) {
            return true;
        }
        for (RelativeBlockVector control : this.gate.getLayout().getControls()) {
            verified = verified && this.portal.getBlockAt(control).getBlock().getType().equals((Object)this.gate.getControlBlock());
        }
        this.verified = verified;
        return verified;
    }

    public boolean wasVerified() {
        if (!Stargate.getGateConfig().verifyPortals()) {
            return true;
        }
        return this.verified;
    }

    public boolean checkIntegrity() {
        if (Stargate.getGateConfig().verifyPortals()) {
            return this.gate.matches(this.portal.getTopLeft(), this.portal.getYaw());
        }
        return true;
    }

    private BlockLocation[] relativeBlockVectorsToBlockLocations(RelativeBlockVector[] vectors) {
        BlockLocation[] locations = new BlockLocation[vectors.length];
        for (int i = 0; i < vectors.length; ++i) {
            locations[i] = this.portal.getBlockAt(vectors[i]);
        }
        return locations;
    }

    public BlockLocation[] getEntrances() {
        if (this.entrances == null) {
            this.entrances = this.relativeBlockVectorsToBlockLocations(this.gate.getLayout().getEntrances());
        }
        return this.entrances;
    }

    public BlockLocation[] getFrame() {
        if (this.frame == null) {
            this.frame = this.relativeBlockVectorsToBlockLocations(this.gate.getLayout().getBorder());
        }
        return this.frame;
    }
}

