/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.portal.property;

import java.util.UUID;
import net.knarcraft.stargate.Stargate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PortalOwner {
    private UUID ownerUUID;
    private String ownerName;

    public PortalOwner(String ownerIdentifier) {
        this.parseIdentifier(ownerIdentifier);
    }

    public PortalOwner(Player player) {
        this.ownerUUID = player.getUniqueId();
        this.ownerName = player.getName();
    }

    public UUID getUUID() {
        return this.ownerUUID;
    }

    public void setUUID(UUID uniqueId) {
        if (this.ownerUUID != null) {
            throw new IllegalArgumentException("An existing UUID cannot be overwritten.");
        }
        this.ownerUUID = uniqueId;
    }

    public String getName() {
        return this.ownerName;
    }

    public String getIdentifier() {
        if (this.ownerUUID != null) {
            return this.ownerUUID.toString();
        }
        return this.ownerName;
    }

    private void parseIdentifier(String ownerIdentifier) {
        String ownerName;
        UUID ownerUUID = null;
        if (ownerIdentifier.length() > 16) {
            try {
                ownerUUID = UUID.fromString(ownerIdentifier);
                OfflinePlayer offlineOwner = Bukkit.getServer().getOfflinePlayer(ownerUUID);
                ownerName = offlineOwner.getName();
            }
            catch (IllegalArgumentException ex) {
                ownerName = ownerIdentifier;
                Stargate.debug("loadAllPortals", "Invalid stargate owner string: " + ownerIdentifier);
            }
        } else {
            ownerName = ownerIdentifier;
        }
        this.ownerName = ownerName;
        this.ownerUUID = ownerUUID;
    }
}

