/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.portal.property;

import java.util.Map;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.portal.property.PortalOption;

public class PortalOptions {
    private final Map<PortalOption, Boolean> options;
    private boolean isFixed;

    public PortalOptions(Map<PortalOption, Boolean> options, boolean hasDestination) {
        this.options = options;
        boolean bl = this.isFixed = hasDestination || this.isRandom() || this.isBungee();
        if (this.isAlwaysOn() && !this.isFixed) {
            this.options.put(PortalOption.ALWAYS_ON, false);
            Stargate.debug("PortalOptions", "Can not create a non-fixed always-on gate. Setting AlwaysOn = false");
        }
        if ((this.isRandom() || this.isBungee()) && !this.isAlwaysOn()) {
            this.options.put(PortalOption.ALWAYS_ON, true);
            Stargate.debug("PortalOptions", "Gate marked as random or bungee, set to always-on");
        }
        if (this.hasNoSign() && !this.isFixed) {
            this.options.put(PortalOption.NO_SIGN, false);
            Stargate.debug("PortalOptions", "Gate marked with no sign, but not fixed. Setting NoSign = false");
        }
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public void setFixed(boolean fixed) {
        this.isFixed = fixed;
    }

    public boolean isAlwaysOn() {
        return this.options.get((Object)PortalOption.ALWAYS_ON);
    }

    public boolean isHidden() {
        return this.options.get((Object)PortalOption.HIDDEN);
    }

    public boolean isPrivate() {
        return this.options.get((Object)PortalOption.PRIVATE);
    }

    public boolean isFree() {
        return this.options.get((Object)PortalOption.FREE);
    }

    public boolean isBackwards() {
        return this.options.get((Object)PortalOption.BACKWARDS);
    }

    public boolean isShown() {
        return this.options.get((Object)PortalOption.SHOW);
    }

    public boolean isNoNetwork() {
        return this.options.get((Object)PortalOption.NO_NETWORK);
    }

    public boolean isRandom() {
        return this.options.get((Object)PortalOption.RANDOM);
    }

    public boolean isBungee() {
        return this.options.get((Object)PortalOption.BUNGEE);
    }

    public boolean isSilent() {
        return this.options.get((Object)PortalOption.SILENT);
    }

    public boolean hasNoSign() {
        return this.options.get((Object)PortalOption.NO_SIGN);
    }
}

