/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.portal;

import java.util.Map;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.container.SignData;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.PortalActivator;
import net.knarcraft.stargate.portal.PortalHandler;
import net.knarcraft.stargate.portal.property.PortalLocation;
import net.knarcraft.stargate.utility.ColorHelper;
import net.knarcraft.stargate.utility.PermissionHelper;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;

public class PortalSignDrawer {
    private final Portal portal;
    private static final ChatColor errorColor = ChatColor.DARK_RED;
    private static ChatColor freeColor;
    private static ChatColor mainColor;
    private static ChatColor highlightColor;
    private static Map<Material, ChatColor> perSignMainColors;
    private static Map<Material, ChatColor> perSignHighlightColors;

    public PortalSignDrawer(Portal portal) {
        this.portal = portal;
    }

    public static void setHighlightColor(ChatColor newHighlightColor) {
        highlightColor = newHighlightColor;
    }

    public static void setMainColor(ChatColor newMainColor) {
        mainColor = newMainColor;
    }

    public static void setFreeColor(ChatColor freeColor) {
        PortalSignDrawer.freeColor = freeColor;
    }

    public static void setPerSignMainColors(Map<Material, ChatColor> signMainColors) {
        perSignMainColors = signMainColors;
    }

    public static void setPerSignHighlightColors(Map<Material, ChatColor> signHighlightColors) {
        perSignHighlightColors = signHighlightColors;
    }

    public static ChatColor getMainColor() {
        return mainColor;
    }

    public static ChatColor getHighlightColor() {
        return highlightColor;
    }

    public void drawSign() {
        Sign sign = this.getSign();
        if (sign == null) {
            return;
        }
        SignData signData = new SignData(sign, this.getMainColor(sign.getType()), this.getHighlightColor(sign.getType()));
        this.drawSign(signData);
    }

    private Sign getSign() {
        Block signBlock = this.portal.getSignLocation().getBlock();
        BlockState state = signBlock.getState();
        if (!(state instanceof Sign)) {
            if (!this.portal.getOptions().hasNoSign()) {
                Stargate.logWarning("Sign block is not a Sign object");
                Stargate.debug("Portal::drawSign", String.format("Block: %s @ %s", signBlock.getType(), signBlock.getLocation()));
            }
            return null;
        }
        Sign sign = (Sign)state;
        return sign;
    }

    private void drawSign(SignData signData) {
        Sign sign = signData.getSign();
        ChatColor highlightColor = signData.getHighlightSignColor();
        ChatColor mainColor = signData.getMainSignColor();
        this.clearSign(sign);
        this.setLine(signData, 0, highlightColor + "-" + mainColor + ColorHelper.translateAllColorCodes(this.portal.getName()) + highlightColor + "-");
        if (!this.portal.getPortalActivator().isActive()) {
            this.drawInactiveSign(signData);
        } else if (this.portal.getOptions().isBungee()) {
            this.drawBungeeSign(signData);
        } else if (this.portal.getOptions().isFixed()) {
            this.drawFixedSign(signData);
        } else {
            this.drawNetworkSign(signData);
        }
        sign.update();
    }

    private void clearSign(Sign sign) {
        for (int index = 0; index <= 3; ++index) {
            sign.setLine(index, "");
        }
    }

    public void drawUnregisteredSign() {
        Sign sign = this.getSign();
        if (sign == null) {
            return;
        }
        this.clearSign(sign);
        sign.setLine(0, ColorHelper.translateAllColorCodes(this.portal.getName()));
        sign.update();
    }

    private void drawNetworkSign(SignData signData) {
        boolean freeGatesColored;
        PortalActivator destinations = this.portal.getPortalActivator();
        int maxIndex = destinations.getDestinations().size() - 1;
        int signLineIndex = 0;
        int destinationIndex = destinations.getDestinations().indexOf(this.portal.getDestinationName());
        boolean bl = freeGatesColored = Stargate.getEconomyConfig().useEconomy() && Stargate.getEconomyConfig().drawFreePortalsColored();
        if (destinationIndex == maxIndex && maxIndex > 1) {
            this.drawNetworkSignLine(signData, freeGatesColored, ++signLineIndex, destinationIndex - 2);
        }
        if (destinationIndex > 0) {
            this.drawNetworkSignLine(signData, freeGatesColored, ++signLineIndex, destinationIndex - 1);
        }
        this.drawNetworkSignChosenLine(signData, freeGatesColored, ++signLineIndex);
        if (maxIndex >= destinationIndex + 1) {
            this.drawNetworkSignLine(signData, freeGatesColored, ++signLineIndex, destinationIndex + 1);
        }
        if (maxIndex >= destinationIndex + 2 && ++signLineIndex <= 3) {
            this.drawNetworkSignLine(signData, freeGatesColored, signLineIndex, destinationIndex + 2);
        }
    }

    private void drawNetworkSignChosenLine(SignData signData, boolean freeGatesColored, int signLineIndex) {
        ChatColor highlightColor = signData.getHighlightSignColor();
        ChatColor mainColor = signData.getMainSignColor();
        if (freeGatesColored) {
            Portal destination = PortalHandler.getByName(this.portal.getDestinationName(), this.portal.getNetwork());
            boolean free = PermissionHelper.isFree(this.portal.getActivePlayer(), this.portal, destination);
            ChatColor nameColor = free ? freeColor : highlightColor;
            this.setLine(signData, signLineIndex, nameColor + ">" + (free ? freeColor : mainColor) + ColorHelper.translateAllColorCodes(this.portal.getDestinationName()) + nameColor + "<");
        } else {
            this.setLine(signData, signLineIndex, highlightColor + ">" + mainColor + ColorHelper.translateAllColorCodes(this.portal.getDestinationName()) + highlightColor + "<");
        }
    }

    public void setLine(SignData signData, int index, String text) {
        ChatColor mainColor = signData.getMainSignColor();
        signData.getSign().setLine(index, mainColor + text);
    }

    private void drawNetworkSignLine(SignData signData, boolean freeGatesColored, int signLineIndex, int destinationIndex) {
        ChatColor mainColor = signData.getMainSignColor();
        PortalActivator destinations = this.portal.getPortalActivator();
        String destinationName = destinations.getDestinations().get(destinationIndex);
        if (freeGatesColored) {
            Portal destination = PortalHandler.getByName(destinationName, this.portal.getNetwork());
            boolean free = PermissionHelper.isFree(this.portal.getActivePlayer(), this.portal, destination);
            this.setLine(signData, signLineIndex, (free ? freeColor : mainColor) + ColorHelper.translateAllColorCodes(destinationName));
        } else {
            this.setLine(signData, signLineIndex, mainColor + ColorHelper.translateAllColorCodes(destinationName));
        }
    }

    private void drawBungeeSign(SignData signData) {
        ChatColor highlightColor = signData.getHighlightSignColor();
        ChatColor mainColor = signData.getMainSignColor();
        this.setLine(signData, 1, Stargate.getString("bungeeSign"));
        this.setLine(signData, 2, highlightColor + ">" + mainColor + ColorHelper.translateAllColorCodes(this.portal.getDestinationName()) + highlightColor + "<");
        this.setLine(signData, 3, highlightColor + "[" + mainColor + ColorHelper.translateAllColorCodes(this.portal.getNetwork()) + highlightColor + "]");
    }

    private void drawInactiveSign(SignData signData) {
        ChatColor highlightColor = signData.getHighlightSignColor();
        ChatColor mainColor = signData.getMainSignColor();
        this.setLine(signData, 1, Stargate.getString("signRightClick"));
        this.setLine(signData, 2, Stargate.getString("signToUse"));
        if (!this.portal.getOptions().isNoNetwork()) {
            this.setLine(signData, 3, highlightColor + "(" + mainColor + ColorHelper.translateAllColorCodes(this.portal.getNetwork()) + highlightColor + ")");
        } else {
            this.setLine(signData, 3, "");
        }
    }

    private void drawFixedSign(SignData signData) {
        ChatColor highlightColor = signData.getHighlightSignColor();
        ChatColor mainColor = signData.getMainSignColor();
        Portal destinationPortal = PortalHandler.getByName(Portal.cleanString(this.portal.getDestinationName()), this.portal.getCleanNetwork());
        String destinationName = this.portal.getOptions().isRandom() ? Stargate.getString("signRandom") : (destinationPortal != null ? destinationPortal.getName() : this.portal.getDestinationName());
        this.setLine(signData, 1, highlightColor + ">" + mainColor + ColorHelper.translateAllColorCodes(destinationName) + highlightColor + "<");
        if (this.portal.getOptions().isNoNetwork()) {
            this.setLine(signData, 2, "");
        } else {
            this.setLine(signData, 2, highlightColor + "(" + mainColor + ColorHelper.translateAllColorCodes(this.portal.getNetwork()) + highlightColor + ")");
        }
        Portal destination = PortalHandler.getByName(Portal.cleanString(this.portal.getDestinationName()), this.portal.getNetwork());
        if (destination == null && !this.portal.getOptions().isRandom()) {
            this.setLine(signData, 3, errorColor + Stargate.getString("signDisconnected"));
        } else {
            this.setLine(signData, 3, "");
        }
    }

    public static void markPortalWithInvalidGate(PortalLocation portalLocation, String gateName, int lineIndex) {
        BlockState blockState = portalLocation.getSignLocation().getBlock().getState();
        if (!(blockState instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)blockState;
        sign.setLine(3, errorColor + Stargate.getString("signInvalidGate"));
        sign.update();
        Stargate.logInfo(String.format("Gate layout on line %d does not exist [%s]", lineIndex, gateName));
    }

    private ChatColor getMainColor(Material signType) {
        ChatColor signColor = perSignMainColors.get(signType);
        if (signColor == null) {
            return mainColor;
        }
        return signColor;
    }

    private ChatColor getHighlightColor(Material signType) {
        ChatColor signColor = perSignHighlightColors.get(signType);
        if (signColor == null) {
            return highlightColor;
        }
        return signColor;
    }
}

