/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.portal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.config.DynmapManager;
import net.knarcraft.stargate.container.BlockLocation;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.PortalHandler;
import net.knarcraft.stargate.portal.PortalSignDrawer;
import net.knarcraft.stargate.utility.PortalFileHelper;
import org.bukkit.World;

public class PortalRegistry {
    private static final Map<BlockLocation, Portal> lookupBlocks = new HashMap<BlockLocation, Portal>();
    private static final Map<BlockLocation, Portal> lookupEntrances = new HashMap<BlockLocation, Portal>();
    private static final Map<BlockLocation, Portal> lookupControls = new HashMap<BlockLocation, Portal>();
    private static final Map<String, Map<String, Portal>> portalLookupByNetwork = new HashMap<String, Map<String, Portal>>();
    private static final Map<String, List<String>> allPortalNetworks = new HashMap<String, List<String>>();
    private static final Map<String, Portal> bungeePortals = new HashMap<String, Portal>();
    private static final List<Portal> allPortals = new ArrayList<Portal>();

    public static void clearPortals() {
        lookupBlocks.clear();
        portalLookupByNetwork.clear();
        lookupEntrances.clear();
        lookupControls.clear();
        allPortals.clear();
        allPortalNetworks.clear();
        bungeePortals.clear();
    }

    public static void clearPortals(World world) {
        ArrayList<Portal> portalsToRemove = new ArrayList<Portal>();
        allPortals.forEach(portal -> {
            if (portal.getWorld().equals(world)) {
                portalsToRemove.add((Portal)portal);
            }
        });
        PortalRegistry.clearPortals(portalsToRemove);
    }

    private static void clearPortals(List<Portal> portalsToRemove) {
        ArrayList portalNames = new ArrayList();
        portalsToRemove.forEach(portal -> portalNames.add(portal.getCleanName()));
        lookupBlocks.keySet().removeIf(key -> portalsToRemove.contains(lookupBlocks.get(key)));
        lookupEntrances.keySet().removeIf(key -> portalsToRemove.contains(lookupEntrances.get(key)));
        lookupControls.keySet().removeIf(key -> portalsToRemove.contains(lookupControls.get(key)));
        portalLookupByNetwork.keySet().forEach(network -> portalLookupByNetwork.get(network).keySet().removeIf(key -> portalsToRemove.contains(portalLookupByNetwork.get(network).get(key))));
        portalLookupByNetwork.keySet().removeIf(key -> portalLookupByNetwork.get(key).isEmpty());
        allPortalNetworks.keySet().forEach(network -> allPortalNetworks.get(network).removeIf(portalNames::contains));
        allPortalNetworks.keySet().removeIf(network -> allPortalNetworks.get(network).isEmpty());
        allPortals.removeIf(portalsToRemove::contains);
    }

    public static List<Portal> getAllPortals() {
        return new ArrayList<Portal>(allPortals);
    }

    public static Map<BlockLocation, Portal> getLookupBlocks() {
        return new HashMap<BlockLocation, Portal>(lookupBlocks);
    }

    public static Map<BlockLocation, Portal> getLookupControls() {
        return new HashMap<BlockLocation, Portal>(lookupControls);
    }

    public static Map<String, Map<String, Portal>> getPortalLookupByNetwork() {
        return new HashMap<String, Map<String, Portal>>(portalLookupByNetwork);
    }

    public static Map<BlockLocation, Portal> getLookupEntrances() {
        return new HashMap<BlockLocation, Portal>(lookupEntrances);
    }

    public static Map<String, List<String>> getAllPortalNetworks() {
        return new HashMap<String, List<String>>(allPortalNetworks);
    }

    public static Map<String, Portal> getBungeePortals() {
        return new HashMap<String, Portal>(bungeePortals);
    }

    public static List<String> getNetwork(String network) {
        return allPortalNetworks.get(network.toLowerCase());
    }

    public static void unregisterPortal(Portal portal, boolean removeAll) {
        Stargate.debug("Unregister", "Unregistering gate " + portal.getName());
        portal.getPortalActivator().deactivate();
        portal.getPortalOpener().closePortal(true);
        String portalName = portal.getCleanName();
        String networkName = portal.getCleanNetwork();
        for (BlockLocation block : portal.getStructure().getFrame()) {
            lookupBlocks.remove((Object)block);
        }
        lookupBlocks.remove((Object)portal.getSignLocation());
        lookupControls.remove((Object)portal.getSignLocation());
        BlockLocation button = portal.getStructure().getButton();
        if (button != null) {
            lookupBlocks.remove((Object)button);
            lookupControls.remove((Object)button);
        }
        for (BlockLocation entrance : portal.getStructure().getEntrances()) {
            lookupEntrances.remove((Object)entrance);
        }
        if (removeAll) {
            allPortals.remove(portal);
        }
        if (portal.getOptions().isBungee()) {
            bungeePortals.remove(portalName);
        } else {
            portalLookupByNetwork.get(networkName).remove(portalName);
            allPortalNetworks.get(networkName).remove(portalName);
            for (String originName : allPortalNetworks.get(networkName)) {
                Portal origin = PortalHandler.getByName(originName, portal.getCleanNetwork());
                if (origin == null || !origin.getDestinationName().equalsIgnoreCase(portalName) || !origin.getStructure().isVerified()) continue;
                if (origin.getOptions().isFixed()) {
                    origin.drawSign();
                }
                if (!origin.getOptions().isAlwaysOn()) continue;
                origin.getPortalOpener().closePortal(true);
            }
        }
        new PortalSignDrawer(portal).drawUnregisteredSign();
        PortalFileHelper.saveAllPortals(portal.getWorld());
        portal.setRegistered(false);
        DynmapManager.removePortalMarker(portal);
    }

    static void registerPortal(Portal portal) {
        BlockLocation button;
        portal.getOptions().setFixed(portal.getDestinationName().length() > 0 || portal.getOptions().isRandom() || portal.getOptions().isBungee());
        String portalName = portal.getCleanName();
        String networkName = portal.getCleanNetwork();
        if (portal.getOptions().isBungee()) {
            bungeePortals.put(portalName, portal);
        } else {
            if (!portalLookupByNetwork.containsKey(networkName)) {
                Stargate.debug("register", String.format("Network %s not in lookupNamesNet, adding", portal.getNetwork()));
                portalLookupByNetwork.put(networkName, new HashMap());
            }
            if (!allPortalNetworks.containsKey(networkName)) {
                Stargate.debug("register", String.format("Network %s not in allPortalsNet, adding", portal.getNetwork()));
                allPortalNetworks.put(networkName, new ArrayList());
            }
            portalLookupByNetwork.get(networkName).put(portalName, portal);
            if (!allPortalNetworks.get(networkName).contains(portalName)) {
                allPortalNetworks.get(networkName).add(portalName);
            } else {
                Stargate.logSevere(String.format("Portal %s on network %s was registered twice. Check your portal database for duplicates.", portal.getName(), portal.getNetwork()));
            }
        }
        for (BlockLocation block : portal.getStructure().getFrame()) {
            lookupBlocks.put(block, portal);
        }
        if (!portal.getOptions().hasNoSign()) {
            lookupBlocks.put(portal.getSignLocation(), portal);
            lookupControls.put(portal.getSignLocation(), portal);
        }
        if ((button = portal.getStructure().getButton()) != null) {
            lookupBlocks.put(button, portal);
            lookupControls.put(button, portal);
        }
        for (BlockLocation entrance : portal.getStructure().getEntrances()) {
            lookupEntrances.put(entrance, portal);
        }
        allPortals.add(portal);
        portal.setRegistered(true);
        DynmapManager.addPortalMarker(portal);
    }
}

