/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.portal;

import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.container.BlockChangeRequest;
import net.knarcraft.stargate.container.BlockLocation;
import net.knarcraft.stargate.event.StargateCloseEvent;
import net.knarcraft.stargate.event.StargateOpenEvent;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.PortalActivator;
import net.knarcraft.stargate.portal.property.PortalOptions;
import org.bukkit.Axis;
import org.bukkit.Material;
import org.bukkit.block.data.Orientable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PortalOpener {
    private boolean isOpen = false;
    private final Portal portal;
    private long triggeredTime;
    private Player player;
    private final PortalActivator portalActivator;

    public PortalOpener(Portal portal, String destination) {
        this.portal = portal;
        this.portalActivator = new PortalActivator(portal, this, destination);
    }

    public boolean isOpen() {
        return this.isOpen || this.portal.getOptions().isAlwaysOn();
    }

    public void setTriggeredTime(long triggeredTime) {
        this.triggeredTime = triggeredTime;
    }

    public PortalActivator getPortalActivator() {
        return this.portalActivator;
    }

    public void openPortal(boolean force) {
        this.openPortal(null, force);
    }

    public void openPortal(Player openFor, boolean force) {
        StargateOpenEvent event = new StargateOpenEvent(openFor, this.portal, force);
        Stargate.getInstance().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || this.isOpen() && !event.getForce()) {
            return;
        }
        Material openType = this.portal.getGate().getPortalOpenBlock();
        Axis axis = openType.createBlockData() instanceof Orientable ? this.portal.getLocation().getRotationAxis() : null;
        for (BlockLocation inside : this.portal.getStructure().getEntrances()) {
            Stargate.addBlockChangeRequest(new BlockChangeRequest(inside, openType, axis));
        }
        this.updatePortalOpenState(openFor);
    }

    private void updatePortalOpenState(Player openFor) {
        this.isOpen = true;
        this.triggeredTime = System.currentTimeMillis() / 1000L;
        Stargate.getStargateConfig().getOpenPortalsQueue().add(this.portal);
        Stargate.getStargateConfig().getActivePortalsQueue().remove(this.portal);
        PortalOptions options = this.portal.getOptions();
        if (options.isAlwaysOn()) {
            return;
        }
        this.player = openFor;
        Portal destination = this.portal.getPortalActivator().getDestination();
        if (destination == null) {
            return;
        }
        boolean thisIsDestination = Portal.cleanString(destination.getDestinationName()).equals(this.portal.getCleanName());
        if (!(options.isRandom() || destination.getOptions().isFixed() && !thisIsDestination || destination.isOpen())) {
            destination.getPortalOpener().openPortal(openFor, false);
            destination.getPortalActivator().setDestination(this.portal);
            if (destination.getStructure().isVerified()) {
                destination.drawSign();
            }
        }
    }

    public void closePortal(boolean force) {
        if (!this.isOpen()) {
            return;
        }
        StargateCloseEvent event = new StargateCloseEvent(this.portal, force);
        Stargate.getInstance().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.portal.getOptions().isAlwaysOn() && !event.getForce()) {
            return;
        }
        Material closedType = this.portal.getGate().getPortalClosedBlock();
        for (BlockLocation entrance : this.portal.getStructure().getEntrances()) {
            Stargate.addBlockChangeRequest(new BlockChangeRequest(entrance, closedType, null));
        }
        this.updatePortalClosedState();
        this.portalActivator.deactivate();
    }

    private void updatePortalClosedState() {
        Portal destination;
        this.player = null;
        this.isOpen = false;
        Stargate.getStargateConfig().getOpenPortalsQueue().remove(this.portal);
        Stargate.getStargateConfig().getActivePortalsQueue().remove(this.portal);
        if (!this.portal.getOptions().isAlwaysOn() && (destination = this.portal.getPortalActivator().getDestination()) != null && destination.isOpen()) {
            destination.getPortalActivator().deactivate();
            destination.getPortalOpener().closePortal(false);
        }
    }

    public boolean isOpenFor(Player player) {
        if (!this.isOpen) {
            return false;
        }
        if (this.portal.getOptions().isAlwaysOn() || this.player == null) {
            return true;
        }
        return player != null && player.getName().equalsIgnoreCase(this.player.getName());
    }

    public long getTriggeredTime() {
        return this.triggeredTime;
    }
}

