/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.portal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.container.BlockLocation;
import net.knarcraft.stargate.container.RelativeBlockVector;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.PortalRegistry;
import net.knarcraft.stargate.portal.property.PortalLocation;
import net.knarcraft.stargate.portal.property.PortalOption;
import net.knarcraft.stargate.portal.property.PortalStructure;
import net.knarcraft.stargate.portal.property.gate.Gate;
import net.knarcraft.stargate.portal.property.gate.GateHandler;
import net.knarcraft.stargate.utility.PermissionHelper;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PortalHandler {
    private PortalHandler() {
    }

    public static Map<String, List<String>> getAllPortalNetworks() {
        return PortalRegistry.getAllPortalNetworks();
    }

    public static Map<String, Portal> getBungeePortals() {
        return PortalRegistry.getBungeePortals();
    }

    public static List<String> getNetwork(String network) {
        return PortalRegistry.getNetwork(network);
    }

    public static List<String> getDestinations(Portal entrancePortal, Player player, String network) {
        ArrayList<String> destinations = new ArrayList<String>();
        for (String destination : PortalRegistry.getAllPortalNetworks().get(network)) {
            Portal portal = PortalHandler.getByName(destination, network);
            if (portal == null || portal.getOptions().isRandom() || portal.getOptions().isAlwaysOn() && !portal.getOptions().isShown() || destination.equals(entrancePortal.getCleanName()) || portal.getOptions().isFixed() && !Portal.cleanString(portal.getDestinationName()).equals(entrancePortal.getCleanName())) continue;
            if (player == null) {
                destinations.add(portal.getName());
                continue;
            }
            if (PermissionHelper.cannotAccessWorld(player, portal.getWorld().getName()) || !PermissionHelper.canSeePortal(player, portal)) continue;
            destinations.add(portal.getName());
        }
        return destinations;
    }

    public static void registerPortal(Portal portal) {
        PortalRegistry.registerPortal(portal);
    }

    static boolean isValidBungeePortal(Map<PortalOption, Boolean> portalOptions, Player player, String destinationName, String network) {
        if (portalOptions.get((Object)PortalOption.BUNGEE).booleanValue()) {
            if (!PermissionHelper.hasPermission(player, "stargate.admin.bungee")) {
                Stargate.getMessageSender().sendErrorMessage((CommandSender)player, Stargate.getString("bungeeDeny"));
                return false;
            }
            if (!Stargate.getGateConfig().enableBungee()) {
                Stargate.getMessageSender().sendErrorMessage((CommandSender)player, Stargate.getString("bungeeDisabled"));
                return false;
            }
            if (destinationName.isEmpty() || network.isEmpty()) {
                Stargate.getMessageSender().sendErrorMessage((CommandSender)player, Stargate.getString("bungeeEmpty"));
                return false;
            }
        }
        return true;
    }

    static Gate findMatchingGate(PortalLocation portalLocation, World world) {
        Block signParent = portalLocation.getSignLocation().getParent();
        BlockLocation parent = new BlockLocation(world, signParent.getX(), signParent.getY(), signParent.getZ());
        Gate[] possibleGates = GateHandler.getGatesByControlBlock(signParent);
        double yaw = portalLocation.getYaw();
        Gate gate = null;
        for (Gate possibleGate : possibleGates) {
            RelativeBlockVector[] vectors = possibleGate.getLayout().getControls();
            portalLocation.setButtonVector(null);
            for (RelativeBlockVector controlVector : vectors) {
                BlockLocation possibleTopLocation = parent.getRelativeLocation(controlVector.invert(), yaw);
                if (possibleGate.matches(possibleTopLocation, portalLocation.getYaw(), true)) {
                    gate = possibleGate;
                    portalLocation.setTopLeft(possibleTopLocation);
                    continue;
                }
                portalLocation.setButtonVector(controlVector);
            }
        }
        return gate;
    }

    static void updatePortalsPointingAtNewPortal(Portal portal) {
        for (String originName : PortalRegistry.getAllPortalNetworks().get(portal.getCleanNetwork())) {
            Portal origin = PortalHandler.getByName(originName, portal.getCleanNetwork());
            if (origin == null || !Portal.cleanString(origin.getDestinationName()).equals(portal.getCleanName()) || !origin.getStructure().isVerified()) continue;
            if (origin.getOptions().isFixed()) {
                origin.drawSign();
            }
            if (!origin.getOptions().isAlwaysOn()) continue;
            origin.getPortalOpener().openPortal(true);
        }
    }

    static Map<PortalOption, Boolean> getPortalOptions(Player player, String destinationName, String options) {
        HashMap<PortalOption, Boolean> portalOptions = new HashMap<PortalOption, Boolean>();
        for (PortalOption option : PortalOption.values()) {
            portalOptions.put(option, options.indexOf(option.getCharacterRepresentation()) != -1 && PermissionHelper.canUseOption(player, option));
        }
        if (((Boolean)portalOptions.get((Object)PortalOption.ALWAYS_ON)).booleanValue() && destinationName.length() == 0) {
            portalOptions.put(PortalOption.ALWAYS_ON, false);
        }
        if (((Boolean)portalOptions.get((Object)PortalOption.SHOW)).booleanValue() && !((Boolean)portalOptions.get((Object)PortalOption.ALWAYS_ON)).booleanValue()) {
            portalOptions.put(PortalOption.SHOW, false);
        }
        if (((Boolean)portalOptions.get((Object)PortalOption.RANDOM)).booleanValue()) {
            portalOptions.put(PortalOption.ALWAYS_ON, true);
            portalOptions.put(PortalOption.SHOW, false);
        }
        if (((Boolean)portalOptions.get((Object)PortalOption.BUNGEE)).booleanValue()) {
            portalOptions.put(PortalOption.ALWAYS_ON, true);
            portalOptions.put(PortalOption.RANDOM, false);
        }
        return portalOptions;
    }

    public static Portal getByName(String name, String network) {
        Map<String, Map<String, Portal>> lookupMap = PortalRegistry.getPortalLookupByNetwork();
        if (!lookupMap.containsKey(network.toLowerCase())) {
            return null;
        }
        return lookupMap.get(network.toLowerCase()).get(name.toLowerCase());
    }

    public static Portal getByEntrance(Location location) {
        return PortalRegistry.getLookupEntrances().get((Object)new BlockLocation(location.getWorld(), location.getBlockX(), location.getBlockY(), location.getBlockZ()));
    }

    public static Portal getByEntrance(Block block) {
        return PortalRegistry.getLookupEntrances().get((Object)new BlockLocation(block));
    }

    public static Portal getByAdjacentEntrance(Location location) {
        return PortalHandler.getByAdjacentEntrance(location, 1);
    }

    public static Portal getByAdjacentEntrance(Location location, int range) {
        ArrayList<BlockLocation> adjacentPositions = new ArrayList<BlockLocation>();
        BlockLocation centerLocation = new BlockLocation(location.getBlock());
        adjacentPositions.add(centerLocation);
        for (int index = 1; index <= range; ++index) {
            adjacentPositions.add(centerLocation.makeRelativeBlockLocation(index, 0, 0));
            adjacentPositions.add(centerLocation.makeRelativeBlockLocation(-index, 0, 0));
            adjacentPositions.add(centerLocation.makeRelativeBlockLocation(0, 0, index));
            adjacentPositions.add(centerLocation.makeRelativeBlockLocation(0, 0, -index));
            if (index >= range) continue;
            adjacentPositions.add(centerLocation.makeRelativeBlockLocation(index, 0, index));
            adjacentPositions.add(centerLocation.makeRelativeBlockLocation(-index, 0, -index));
            adjacentPositions.add(centerLocation.makeRelativeBlockLocation(index, 0, -index));
            adjacentPositions.add(centerLocation.makeRelativeBlockLocation(-index, 0, index));
        }
        for (BlockLocation adjacentPosition : adjacentPositions) {
            Portal portal = PortalRegistry.getLookupEntrances().get((Object)adjacentPosition);
            if (portal == null) continue;
            return portal;
        }
        return null;
    }

    public static Portal getByControl(Block block) {
        return PortalRegistry.getLookupControls().get((Object)new BlockLocation(block));
    }

    public static Portal getByBlock(Block block) {
        return PortalRegistry.getLookupBlocks().get((Object)new BlockLocation(block));
    }

    public static Portal getBungeePortal(String name) {
        return PortalRegistry.getBungeePortals().get(name.toLowerCase());
    }

    public static Map<PortalOption, Boolean> getPortalOptions(String[] portalData) {
        HashMap<PortalOption, Boolean> portalOptions = new HashMap<PortalOption, Boolean>();
        PortalOption[] portalOptionArray = PortalOption.values();
        int n = portalOptionArray.length;
        for (int i = 0; i < n; ++i) {
            PortalOption option;
            int saveIndex = (option = portalOptionArray[i]).getSaveIndex();
            portalOptions.put(option, portalData.length > saveIndex && Boolean.parseBoolean(portalData[saveIndex]));
        }
        return portalOptions;
    }

    public static int openAlwaysOpenPortals() {
        int alwaysOpenCount = 0;
        for (Portal portal : PortalRegistry.getAllPortals()) {
            if (!portal.getOptions().isFixed() || (!Stargate.getGateConfig().enableBungee() || !portal.getOptions().isBungee()) && (portal.getPortalActivator().getDestination() == null || !portal.getOptions().isAlwaysOn())) continue;
            portal.getPortalOpener().openPortal(true);
            ++alwaysOpenCount;
        }
        return alwaysOpenCount;
    }

    public static void verifyAllPortals() {
        ArrayList<Portal> invalidPortals = new ArrayList<Portal>();
        for (Portal portal : PortalRegistry.getAllPortals()) {
            PortalStructure structure = portal.getStructure();
            if (structure.wasVerified() || structure.isVerified() && structure.checkIntegrity()) continue;
            invalidPortals.add(portal);
        }
        for (Portal portal : invalidPortals) {
            PortalHandler.unregisterInvalidPortal(portal);
        }
    }

    private static void unregisterInvalidPortal(Portal portal) {
        for (RelativeBlockVector control : portal.getGate().getLayout().getControls()) {
            Block block = portal.getBlockAt(control).getBlock();
            if (block.getType().equals((Object)portal.getGate().getControlBlock())) continue;
            Stargate.debug("PortalHandler::destroyInvalidPortal", "Control Block Type == " + block.getType().name());
        }
        PortalRegistry.unregisterPortal(portal, false);
        Stargate.logInfo(String.format("Destroying stargate at %s", portal));
    }

    public static void closeAllPortals() {
        Stargate.logInfo("Closing all stargates.");
        for (Portal portal : PortalRegistry.getAllPortals()) {
            if (portal == null) continue;
            portal.getPortalOpener().closePortal(true);
        }
    }

    public static String filterName(String input) {
        if (input == null) {
            return "";
        }
        return input.replaceAll("[|:#]", "").trim();
    }
}

