/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.portal;

import java.util.List;
import java.util.Map;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.container.BlockLocation;
import net.knarcraft.stargate.container.RelativeBlockVector;
import net.knarcraft.stargate.event.StargateCreateEvent;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.PortalHandler;
import net.knarcraft.stargate.portal.property.PortalLocation;
import net.knarcraft.stargate.portal.property.PortalOption;
import net.knarcraft.stargate.portal.property.PortalOptions;
import net.knarcraft.stargate.portal.property.PortalOwner;
import net.knarcraft.stargate.portal.property.gate.Gate;
import net.knarcraft.stargate.portal.property.gate.GateHandler;
import net.knarcraft.stargate.utility.DirectionHelper;
import net.knarcraft.stargate.utility.EconomyHelper;
import net.knarcraft.stargate.utility.PermissionHelper;
import net.knarcraft.stargate.utility.PortalFileHelper;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.SignChangeEvent;

public class PortalCreator {
    private Portal portal;
    private final SignChangeEvent event;
    private final Player player;

    public PortalCreator(SignChangeEvent event, Player player) {
        this.event = event;
        this.player = player;
    }

    public Portal createPortal() {
        String world;
        Portal portal;
        BlockLocation signLocation = new BlockLocation(this.event.getBlock());
        Block signControlBlock = signLocation.getParent();
        if (signControlBlock == null || GateHandler.getGatesByControlBlock(signControlBlock).length == 0) {
            Stargate.debug("createPortal", "Control block not registered");
            return null;
        }
        if (PortalHandler.getByBlock(signControlBlock) != null) {
            Stargate.debug("createPortal", "idParent belongs to existing stargate");
            return null;
        }
        String portalName = PortalHandler.filterName(this.event.getLine(0));
        String destinationName = PortalHandler.filterName(this.event.getLine(1));
        String network = PortalHandler.filterName(this.event.getLine(2));
        String options = PortalHandler.filterName(this.event.getLine(3)).toLowerCase();
        Map<PortalOption, Boolean> portalOptions = PortalHandler.getPortalOptions(this.player, destinationName, options);
        float yaw = DirectionHelper.getYawFromLocationDifference(signControlBlock.getLocation(), signLocation.getLocation());
        BlockFace buttonFacing = DirectionHelper.getBlockFaceFromYaw(yaw);
        PortalLocation portalLocation = new PortalLocation();
        portalLocation.setButtonFacing(buttonFacing).setYaw(yaw).setSignLocation(signLocation);
        Stargate.debug("createPortal", "Finished getting all portal info");
        Gate gate = PortalHandler.findMatchingGate(portalLocation, this.player.getWorld());
        if (gate == null || portalLocation.getButtonVector() == null) {
            Stargate.debug("createPortal", "Could not find matching gate layout");
            return null;
        }
        if (!PortalHandler.isValidBungeePortal(portalOptions, this.player, destinationName, network)) {
            Stargate.debug("createPortal", "Portal is an invalid bungee portal");
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (PortalOption option : portalOptions.keySet()) {
            builder.append(option.getCharacterRepresentation()).append(" = ").append(portalOptions.get((Object)option)).append(" ");
        }
        Stargate.debug("createPortal", builder.toString());
        if (!(portalOptions.get((Object)PortalOption.BUNGEE).booleanValue() || network.length() >= 1 && network.length() <= Stargate.getMaxNameNetworkLength())) {
            network = Stargate.getDefaultNetwork();
        }
        boolean deny = false;
        String denyMessage = "";
        if (!portalOptions.get((Object)PortalOption.BUNGEE).booleanValue() && !PermissionHelper.canCreateNetworkGate(this.player, network)) {
            Stargate.debug("createPortal", "Player doesn't have create permissions on network. Trying personal");
            if (PermissionHelper.canCreatePersonalPortal(this.player)) {
                network = this.player.getName();
                if (network.length() > Stargate.getMaxNameNetworkLength()) {
                    network = network.substring(0, Stargate.getMaxNameNetworkLength());
                }
                Stargate.debug("createPortal", "Creating personal portal");
                Stargate.getMessageSender().sendErrorMessage((CommandSender)this.player, Stargate.getString("createPersonal"));
            } else {
                Stargate.debug("createPortal", "Player does not have access to network");
                deny = true;
                denyMessage = Stargate.getString("createNetDeny");
            }
        }
        String gateName = gate.getFilename();
        gateName = gateName.substring(0, gateName.indexOf(46));
        if (!deny && !PermissionHelper.canCreatePortal(this.player, gateName)) {
            Stargate.debug("createPortal", "Player does not have access to gate layout");
            deny = true;
            denyMessage = Stargate.getString("createGateDeny");
        }
        if (!portalOptions.get((Object)PortalOption.BUNGEE).booleanValue() && !deny && destinationName.length() > 0 && (portal = PortalHandler.getByName(destinationName, network)) != null && PermissionHelper.cannotAccessWorld(this.player, world = portal.getWorld().getName())) {
            Stargate.debug("canCreateNetworkGate", "Player does not have access to destination world");
            deny = true;
            denyMessage = Stargate.getString("createWorldDeny");
        }
        if (PortalCreator.conflictsWithExistingPortal(gate, portalLocation.getTopLeft(), yaw, this.player)) {
            return null;
        }
        PortalOwner owner = new PortalOwner(this.player);
        this.portal = new Portal(portalLocation, null, destinationName, portalName, network, gate, owner, portalOptions);
        return this.validatePortal(denyMessage, this.event.getLines(), deny);
    }

    public Portal validatePortal(String denyMessage, String[] lines, boolean deny) {
        PortalLocation portalLocation = this.portal.getLocation();
        Gate gate = this.portal.getStructure().getGate();
        PortalOptions portalOptions = this.portal.getOptions();
        String portalName = this.portal.getName();
        String destinationName = this.portal.getDestinationName();
        int createCost = Stargate.getEconomyConfig().getCreateCost(this.player, gate);
        StargateCreateEvent stargateCreateEvent = new StargateCreateEvent(this.player, this.portal, lines, deny, denyMessage, createCost);
        Stargate.getInstance().getServer().getPluginManager().callEvent((Event)stargateCreateEvent);
        if (stargateCreateEvent.isCancelled()) {
            return null;
        }
        if (stargateCreateEvent.getDeny()) {
            if (!stargateCreateEvent.getDenyReason().trim().isEmpty()) {
                Stargate.getMessageSender().sendErrorMessage((CommandSender)this.player, stargateCreateEvent.getDenyReason());
            }
            return null;
        }
        createCost = stargateCreateEvent.getCost();
        if (!this.checkIfNewPortalIsValid(createCost, portalName)) {
            return null;
        }
        if (!portalOptions.isAlwaysOn()) {
            PortalFileHelper.generatePortalButton(this.portal, portalLocation.getButtonFacing());
        }
        PortalHandler.registerPortal(this.portal);
        this.updateNewPortalOpenState(destinationName);
        if (!this.portal.getOptions().isBungee()) {
            PortalHandler.updatePortalsPointingAtNewPortal(this.portal);
        }
        PortalFileHelper.saveAllPortals(this.portal.getWorld());
        return this.portal;
    }

    private boolean checkIfNewPortalIsValid(int cost, String portalName) {
        if (this.portal.getCleanName().length() < 1 || this.portal.getCleanName().length() > Stargate.getMaxNameNetworkLength()) {
            Stargate.debug("createPortal", String.format("Name length error. %s is too long.", this.portal.getCleanName()));
            Stargate.getMessageSender().sendErrorMessage((CommandSender)this.player, Stargate.getString("createNameLength"));
            return false;
        }
        if (this.portal.getOptions().isBungee()) {
            if (PortalHandler.getBungeePortals().get(this.portal.getCleanName()) != null) {
                Stargate.debug("createPortal::Bungee", "Gate name duplicate");
                Stargate.getMessageSender().sendErrorMessage((CommandSender)this.player, Stargate.getString("createExists"));
                return false;
            }
        } else {
            if (PortalHandler.getByName(this.portal.getCleanName(), this.portal.getCleanNetwork()) != null) {
                Stargate.debug("createPortal", "Gate name duplicate");
                Stargate.getMessageSender().sendErrorMessage((CommandSender)this.player, Stargate.getString("createExists"));
                return false;
            }
            List<String> networkList = PortalHandler.getAllPortalNetworks().get(this.portal.getCleanNetwork());
            int maxGates = Stargate.getGateConfig().maxGatesEachNetwork();
            if (maxGates > 0 && networkList != null && networkList.size() >= maxGates) {
                Stargate.getMessageSender().sendErrorMessage((CommandSender)this.player, Stargate.getString("createFull"));
                return false;
            }
        }
        if (cost > 0) {
            if (!EconomyHelper.chargePlayerIfNecessary(this.player, cost)) {
                EconomyHelper.sendInsufficientFundsMessage(portalName, this.player, cost);
                Stargate.debug("createPortal", "Insufficient Funds");
                return false;
            }
            EconomyHelper.sendDeductMessage(portalName, this.player, cost);
        }
        return true;
    }

    private void updateNewPortalOpenState(String destinationName) {
        this.portal.drawSign();
        if (this.portal.getOptions().isRandom() || this.portal.getOptions().isBungee()) {
            this.portal.getPortalOpener().openPortal(true);
        } else if (this.portal.getOptions().isAlwaysOn()) {
            Portal destinationPortal = PortalHandler.getByName(destinationName, this.portal.getCleanNetwork());
            if (destinationPortal != null) {
                this.portal.getPortalOpener().openPortal(true);
                destinationPortal.drawSign();
            }
        } else {
            for (BlockLocation entrance : this.portal.getStructure().getEntrances()) {
                entrance.setType(this.portal.getGate().getPortalClosedBlock());
            }
        }
    }

    private static boolean conflictsWithExistingPortal(Gate gate, BlockLocation topLeft, double yaw, Player player) {
        for (RelativeBlockVector borderVector : gate.getLayout().getBorder()) {
            BlockLocation borderBlockLocation = topLeft.getRelativeLocation(borderVector, yaw);
            if (PortalHandler.getByBlock(borderBlockLocation.getBlock()) == null) continue;
            Stargate.debug("createPortal", "Gate conflicts with existing gate");
            Stargate.getMessageSender().sendErrorMessage((CommandSender)player, Stargate.getString("createConflict"));
            return true;
        }
        return false;
    }
}

