/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.portal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.event.StargateActivateEvent;
import net.knarcraft.stargate.event.StargateDeactivateEvent;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.PortalHandler;
import net.knarcraft.stargate.portal.PortalOpener;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PortalActivator {
    private final Portal portal;
    private final PortalOpener opener;
    private List<String> destinations = new ArrayList<String>();
    private String destination;
    private String lastDestination = "";
    private Player activePlayer;

    public PortalActivator(Portal portal, PortalOpener portalOpener, String destination) {
        this.portal = portal;
        this.opener = portalOpener;
        this.destination = destination;
    }

    public Player getActivePlayer() {
        return this.activePlayer;
    }

    public List<String> getDestinations() {
        return new ArrayList<String>(this.destinations);
    }

    public Portal getDestination(Player player) {
        String portalNetwork = this.portal.getCleanNetwork();
        if (this.portal.getOptions().isRandom()) {
            List<String> destinations = PortalHandler.getDestinations(this.portal, player, portalNetwork);
            if (destinations.size() == 0) {
                return null;
            }
            String destination = destinations.get(new Random().nextInt(destinations.size()));
            return PortalHandler.getByName(Portal.cleanString(destination), portalNetwork);
        }
        return PortalHandler.getByName(Portal.cleanString(this.destination), portalNetwork);
    }

    public Portal getDestination() {
        return this.getDestination(null);
    }

    public void setDestination(Portal destination) {
        this.setDestination(destination.getName());
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestinationName() {
        return this.destination;
    }

    boolean activate(Player player) {
        this.destination = "";
        this.destinations.clear();
        Stargate.getStargateConfig().getActivePortalsQueue().add(this.portal);
        this.activePlayer = player;
        String network = this.portal.getCleanNetwork();
        this.destinations = PortalHandler.getDestinations(this.portal, player, network);
        if (Stargate.getGateConfig().sortNetworkDestinations()) {
            this.destinations.sort(Comparator.comparing(Portal::cleanString));
        }
        if (Stargate.getGateConfig().rememberDestination() && !this.lastDestination.isEmpty() && this.destinations.contains(this.lastDestination)) {
            this.destination = this.lastDestination;
        }
        return this.triggerStargateActivationEvent(player);
    }

    private boolean triggerStargateActivationEvent(Player player) {
        StargateActivateEvent event = new StargateActivateEvent(this.portal, player, this.destinations, this.destination);
        Stargate.getInstance().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            Stargate.getStargateConfig().getActivePortalsQueue().remove(this.portal);
            return false;
        }
        this.destination = event.getDestination();
        this.destinations = event.getDestinations();
        this.portal.drawSign();
        return true;
    }

    public void deactivate() {
        StargateDeactivateEvent event = new StargateDeactivateEvent(this.portal);
        Stargate.getInstance().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        Stargate.getStargateConfig().getActivePortalsQueue().remove(this.portal);
        if (this.portal.getOptions().isFixed()) {
            return;
        }
        this.destinations.clear();
        this.destination = "";
        this.activePlayer = null;
        this.portal.drawSign();
    }

    public boolean isActive() {
        return this.portal.getOptions().isFixed() || this.destinations.size() > 0;
    }

    public void cycleDestination(Player player) {
        this.cycleDestination(player, 1);
    }

    public void cycleDestination(Player player, int direction) {
        if (direction != 1 && direction != -1) {
            throw new IllegalArgumentException("The destination direction must be 1 or -1.");
        }
        boolean activate = false;
        if (!this.isActive() || this.getActivePlayer() != player) {
            if (!this.activate(player)) {
                return;
            }
            activate = true;
            Stargate.debug("cycleDestination", "Network Size: " + PortalHandler.getNetwork(this.portal.getCleanNetwork()).size());
            Stargate.debug("cycleDestination", "Player has access to: " + this.destinations.size());
        }
        if (this.destinations.size() == 0) {
            if (!this.portal.getOptions().isSilent()) {
                Stargate.getMessageSender().sendErrorMessage((CommandSender)player, Stargate.getString("destEmpty"));
            }
            return;
        }
        if (!Stargate.getGateConfig().rememberDestination() || !activate || this.lastDestination.isEmpty()) {
            this.cycleDestination(direction);
        }
        this.opener.setTriggeredTime(System.currentTimeMillis() / 1000L);
        this.portal.drawSign();
    }

    private void cycleDestination(int direction) {
        int index = this.destinations.indexOf(this.destination);
        if ((index += direction) >= this.destinations.size()) {
            index = 0;
        } else if (index < 0) {
            index = this.destinations.size() - 1;
        }
        this.lastDestination = this.destination = this.destinations.get(index);
    }
}

