/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.portal;

import java.util.Map;
import net.knarcraft.stargate.container.BlockLocation;
import net.knarcraft.stargate.container.RelativeBlockVector;
import net.knarcraft.stargate.portal.PortalActivator;
import net.knarcraft.stargate.portal.PortalOpener;
import net.knarcraft.stargate.portal.PortalSignDrawer;
import net.knarcraft.stargate.portal.property.PortalLocation;
import net.knarcraft.stargate.portal.property.PortalOption;
import net.knarcraft.stargate.portal.property.PortalOptions;
import net.knarcraft.stargate.portal.property.PortalOwner;
import net.knarcraft.stargate.portal.property.PortalStructure;
import net.knarcraft.stargate.portal.property.gate.Gate;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class Portal {
    private final String name;
    private final String cleanName;
    private final String network;
    private final String cleanNetwork;
    private final PortalOwner portalOwner;
    private boolean isRegistered;
    private final PortalOptions options;
    private final PortalOpener portalOpener;
    private final PortalLocation location;
    private final PortalSignDrawer signDrawer;
    private final PortalStructure structure;
    private final PortalActivator portalActivator;

    public Portal(PortalLocation portalLocation, BlockLocation button, String destination, String name, String network, Gate gate, PortalOwner portalOwner, Map<PortalOption, Boolean> options) {
        this.location = portalLocation;
        this.network = network;
        this.name = name;
        this.portalOwner = portalOwner;
        this.options = new PortalOptions(options, destination.length() > 0);
        this.signDrawer = new PortalSignDrawer(this);
        this.portalOpener = new PortalOpener(this, destination);
        this.structure = new PortalStructure(this, gate, button);
        this.portalActivator = this.portalOpener.getPortalActivator();
        this.cleanName = Portal.cleanString(name);
        this.cleanNetwork = Portal.cleanString(network);
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
    }

    public PortalLocation getLocation() {
        return this.location;
    }

    public PortalStructure getStructure() {
        return this.structure;
    }

    public PortalActivator getPortalActivator() {
        return this.portalActivator;
    }

    public void drawSign() {
        this.signDrawer.drawSign();
    }

    public PortalOptions getOptions() {
        return this.options;
    }

    public boolean isOpen() {
        return this.portalOpener.isOpen();
    }

    public Player getActivePlayer() {
        return this.portalActivator.getActivePlayer();
    }

    public String getNetwork() {
        return this.network;
    }

    public String getCleanNetwork() {
        return this.cleanNetwork;
    }

    public long getTriggeredTime() {
        return this.portalOpener.getTriggeredTime();
    }

    public String getName() {
        return this.name;
    }

    public String getCleanName() {
        return this.cleanName;
    }

    public PortalOpener getPortalOpener() {
        return this.portalOpener;
    }

    public String getDestinationName() {
        return this.portalOpener.getPortalActivator().getDestinationName();
    }

    public Gate getGate() {
        return this.structure.getGate();
    }

    public PortalOwner getOwner() {
        return this.portalOwner;
    }

    public boolean isOwner(Player player) {
        if (this.portalOwner.getUUID() != null) {
            return player.getUniqueId().compareTo(this.portalOwner.getUUID()) == 0;
        }
        return player.getName().equalsIgnoreCase(this.portalOwner.getName());
    }

    public World getWorld() {
        return this.location.getWorld();
    }

    public BlockLocation getSignLocation() {
        return this.location.getSignLocation();
    }

    public float getYaw() {
        return this.location.getYaw();
    }

    public BlockLocation getTopLeft() {
        return this.location.getTopLeft();
    }

    public BlockLocation getBlockAt(RelativeBlockVector vector) {
        return this.getTopLeft().getRelativeLocation(vector, this.getYaw());
    }

    public static String cleanString(String string) {
        return ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)string)).toLowerCase();
    }

    public String toString() {
        return String.format("Portal [id=%s, network=%s name=%s, type=%s]", new Object[]{this.getSignLocation(), this.network, this.name, this.structure.getGate().getFilename()});
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cleanName == null ? 0 : this.cleanName.hashCode());
        result = 31 * result + (this.cleanNetwork == null ? 0 : this.cleanNetwork.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Portal other = (Portal)object;
        if (this.cleanName == null ? other.cleanName != null : !this.cleanName.equalsIgnoreCase(other.cleanName)) {
            return false;
        }
        if (this.cleanNetwork == null) {
            return other.cleanNetwork == null;
        }
        return this.cleanNetwork.equalsIgnoreCase(other.cleanNetwork);
    }
}

