/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.listener;

import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.config.StargateConfig;
import net.knarcraft.stargate.portal.PortalRegistry;
import net.knarcraft.stargate.utility.PortalFileHelper;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;

public class WorldEventListener
implements Listener {
    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        StargateConfig config = Stargate.getStargateConfig();
        if (!config.getManagedWorlds().contains(event.getWorld().getName()) && PortalFileHelper.loadAllPortals(event.getWorld())) {
            config.addManagedWorld(event.getWorld().getName());
        }
    }

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent event) {
        Stargate.debug("onWorldUnload", "Reloading all Stargates");
        World world = event.getWorld();
        String worldName = world.getName();
        StargateConfig config = Stargate.getStargateConfig();
        if (config.getManagedWorlds().contains(worldName)) {
            config.removeManagedWorld(worldName);
            PortalRegistry.clearPortals(world);
        }
    }
}

