/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.listener;

import java.util.List;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.PortalHandler;
import net.knarcraft.stargate.portal.teleporter.VehicleTeleporter;
import net.knarcraft.stargate.utility.EconomyHelper;
import net.knarcraft.stargate.utility.EntityHelper;
import net.knarcraft.stargate.utility.TeleportHelper;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleMoveEvent;

public class VehicleEventListener
implements Listener {
    @EventHandler
    public void onVehicleMove(VehicleMoveEvent event) {
        if (!Stargate.getGateConfig().handleVehicles()) {
            return;
        }
        List passengers = event.getVehicle().getPassengers();
        Vehicle vehicle = event.getVehicle();
        int entitySize = EntityHelper.getEntityMaxSizeInt((Entity)vehicle);
        Portal entrancePortal = EntityHelper.getEntityMaxSize((Entity)vehicle) > 1.0 ? PortalHandler.getByAdjacentEntrance(event.getTo(), entitySize - 1) : PortalHandler.getByEntrance(event.getTo());
        if (entrancePortal == null || !entrancePortal.isOpen() || entrancePortal.getOptions().isBungee()) {
            return;
        }
        VehicleEventListener.teleportVehicle(passengers, entrancePortal, vehicle);
    }

    private static void teleportVehicle(List<Entity> passengers, Portal entrancePortal, Vehicle vehicle) {
        String route = "VehicleEventListener::teleportVehicle";
        if (!passengers.isEmpty() && TeleportHelper.containsPlayer(passengers)) {
            Stargate.debug(route, "Found passenger vehicle");
            VehicleEventListener.teleportPlayerAndVehicle(entrancePortal, vehicle);
        } else {
            Stargate.debug(route, "Found vehicle without players");
            Portal destinationPortal = entrancePortal.getPortalActivator().getDestination();
            if (destinationPortal == null) {
                Stargate.debug(route, "Unable to find portal destination");
                return;
            }
            Stargate.debug("vehicleTeleport", destinationPortal.getWorld() + " " + destinationPortal.getSignLocation());
            new VehicleTeleporter(destinationPortal, vehicle).teleportEntity(entrancePortal);
        }
    }

    private static void teleportPlayerAndVehicle(Portal entrancePortal, Vehicle vehicle) {
        Vehicle rootEntity = vehicle;
        while (rootEntity.getVehicle() != null) {
            rootEntity = rootEntity.getVehicle();
        }
        List<Player> players = TeleportHelper.getPlayers(rootEntity.getPassengers());
        Portal destinationPortal = null;
        for (Player player : players) {
            Portal possibleDestinationPortal;
            if (!entrancePortal.getPortalOpener().isOpenFor(player) || (possibleDestinationPortal = entrancePortal.getPortalActivator().getDestination(player)) == null) continue;
            destinationPortal = possibleDestinationPortal;
        }
        boolean cancelTeleport = false;
        for (Player player : players) {
            if (destinationPortal == null) {
                cancelTeleport = true;
                if (entrancePortal.getOptions().isSilent()) continue;
                Stargate.getMessageSender().sendErrorMessage((CommandSender)player, Stargate.getString("invalidMsg"));
                continue;
            }
            if (TeleportHelper.playerCanTeleport(player, entrancePortal, destinationPortal)) continue;
            cancelTeleport = true;
        }
        if (cancelTeleport) {
            return;
        }
        for (Player player : players) {
            int cost = EconomyHelper.getUseCost(player, entrancePortal, destinationPortal);
            if (cost <= 0 || !EconomyHelper.cannotPayTeleportFee(entrancePortal, player, cost)) continue;
            return;
        }
        boolean bl = new VehicleTeleporter(destinationPortal, vehicle).teleportEntity(entrancePortal);
        if (bl) {
            if (!entrancePortal.getOptions().isSilent()) {
                for (Player player : players) {
                    Stargate.getMessageSender().sendSuccessMessage((CommandSender)player, Stargate.getString("teleportMsg"));
                }
            }
            entrancePortal.getPortalOpener().closePortal(false);
        }
    }
}

