/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.listener;

import java.util.ArrayList;
import java.util.List;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.container.FromTheEndTeleportation;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.PortalHandler;
import net.knarcraft.stargate.portal.teleporter.PlayerTeleporter;
import net.knarcraft.stargate.utility.PermissionHelper;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.world.PortalCreateEvent;

public class PortalEventListener
implements Listener {
    private static final List<FromTheEndTeleportation> playersFromTheEnd = new ArrayList<FromTheEndTeleportation>();

    @EventHandler
    public void onPortalCreation(PortalCreateEvent event) {
        Entity entity;
        if (event.isCancelled()) {
            return;
        }
        if (event.getReason() == PortalCreateEvent.CreateReason.NETHER_PAIR && (entity = event.getEntity()) != null && PortalHandler.getByAdjacentEntrance(entity.getLocation()) != null) {
            Stargate.debug("PortalEventListener::onPortalCreation", "Cancelled nether portal create event");
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityPortalEnter(EntityPortalEnterEvent event) {
        Location location = event.getLocation();
        World world = location.getWorld();
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (location.getBlock().getType() == Material.END_PORTAL && world != null && world.getEnvironment() == World.Environment.THE_END) {
                Portal portal = PortalHandler.getByAdjacentEntrance(location);
                if (portal == null) {
                    return;
                }
                playersFromTheEnd.removeIf(teleportation -> teleportation.getPlayer() == player);
                if (PermissionHelper.playerCannotTeleport(portal, portal.getPortalActivator().getDestination(), player, null)) {
                    playersFromTheEnd.add(new FromTheEndTeleportation(player, portal));
                }
                playersFromTheEnd.add(new FromTheEndTeleportation(player, portal.getPortalActivator().getDestination()));
            }
        }
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        Player respawningPlayer = event.getPlayer();
        int playerIndex = playersFromTheEnd.indexOf(new FromTheEndTeleportation(respawningPlayer, null));
        if (playerIndex == -1) {
            return;
        }
        FromTheEndTeleportation teleportation = playersFromTheEnd.get(playerIndex);
        playersFromTheEnd.remove(playerIndex);
        Portal exitPortal = teleportation.getExit();
        event.setRespawnLocation(new PlayerTeleporter(exitPortal, respawningPlayer).getExit());
        exitPortal.getPortalOpener().closePortal(false);
    }
}

