/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.listener;

import java.util.HashMap;
import java.util.Map;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.config.MessageSender;
import net.knarcraft.stargate.container.BlockLocation;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.PortalActivator;
import net.knarcraft.stargate.portal.PortalHandler;
import net.knarcraft.stargate.portal.teleporter.PlayerTeleporter;
import net.knarcraft.stargate.portal.teleporter.VehicleTeleporter;
import net.knarcraft.stargate.utility.BungeeHelper;
import net.knarcraft.stargate.utility.MaterialHelper;
import net.knarcraft.stargate.utility.PermissionHelper;
import net.knarcraft.stargate.utility.TeleportHelper;
import net.knarcraft.stargate.utility.UUIDMigrationHelper;
import net.knarcraft.stargate.utility.UpdateChecker;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class PlayerEventListener
implements Listener {
    private static final Map<Player, Long> previousEventTimes = new HashMap<Player, Long>();

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUIDMigrationHelper.migrateUUID((OfflinePlayer)player);
        String availableUpdate = Stargate.getUpdateAvailable();
        if (availableUpdate != null && Stargate.getStargateConfig().alertAdminsAboutUpdates() && player.hasPermission("stargate.admin")) {
            String updateMessage = UpdateChecker.getUpdateAvailableString(availableUpdate, Stargate.getPluginVersion());
            Stargate.getMessageSender().sendErrorMessage((CommandSender)player, updateMessage);
        }
        if (!Stargate.getGateConfig().enableBungee()) {
            return;
        }
        String destination = BungeeHelper.removeFromQueue(player.getUniqueId());
        if (destination == null) {
            return;
        }
        Portal portal = PortalHandler.getBungeePortal(destination);
        if (portal == null) {
            Stargate.debug("PlayerJoin", "Error fetching destination portal: " + destination);
            return;
        }
        new PlayerTeleporter(portal, player).teleport(portal, null);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.isCancelled() || event.getTo() == null) {
            return;
        }
        BlockLocation fromLocation = new BlockLocation(event.getFrom().getBlock());
        BlockLocation toLocation = new BlockLocation(event.getTo().getBlock());
        Player player = event.getPlayer();
        if (!this.isRelevantMoveEvent(event, player, fromLocation, toLocation)) {
            return;
        }
        Portal entrancePortal = PortalHandler.getByEntrance(toLocation);
        Portal destination = entrancePortal.getPortalActivator().getDestination(player);
        Entity playerVehicle = player.getVehicle();
        if (playerVehicle == null || playerVehicle instanceof LivingEntity && Stargate.getGateConfig().handleVehicles()) {
            this.teleportPlayer(playerVehicle, player, entrancePortal, destination, event);
        }
    }

    private void teleportPlayer(Entity playerVehicle, Player player, Portal entrancePortal, Portal destination, PlayerMoveEvent event) {
        if (playerVehicle instanceof LivingEntity) {
            AbstractHorse horse;
            if (playerVehicle instanceof AbstractHorse && !(horse = (AbstractHorse)playerVehicle).isTamed()) {
                horse.setTamed(true);
                horse.setOwner((AnimalTamer)player);
            }
            player.setVelocity(new Vector());
            new VehicleTeleporter(destination, (Vehicle)playerVehicle).teleportEntity(entrancePortal);
        } else {
            new PlayerTeleporter(destination, player).teleportPlayer(entrancePortal, event);
        }
        if (!entrancePortal.getOptions().isSilent()) {
            Stargate.getMessageSender().sendSuccessMessage((CommandSender)player, Stargate.getString("teleportMsg"));
        }
        entrancePortal.getPortalOpener().closePortal(false);
    }

    private boolean isRelevantMoveEvent(PlayerMoveEvent event, Player player, BlockLocation fromLocation, BlockLocation toLocation) {
        if (fromLocation.equals((Object)toLocation)) {
            return false;
        }
        Portal entrancePortal = PortalHandler.getByEntrance(toLocation);
        if (entrancePortal == null) {
            return false;
        }
        Portal destination = entrancePortal.getPortalActivator().getDestination(player);
        if (!entrancePortal.getOptions().isBungee() && destination == null) {
            return false;
        }
        if (PermissionHelper.playerCannotTeleport(entrancePortal, destination, player, event)) {
            return false;
        }
        if (entrancePortal.getOptions().isBungee()) {
            if (BungeeHelper.bungeeTeleport(player, entrancePortal, event) && !entrancePortal.getOptions().isSilent()) {
                Stargate.getMessageSender().sendSuccessMessage((CommandSender)player, Stargate.getString("teleportMsg"));
            }
            return false;
        }
        return TeleportHelper.noLeashedCreaturesPreventTeleportation(player);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            this.handleRightClickBlock(event, player, block, event.getHand());
        } else if (event.getAction() == Action.LEFT_CLICK_BLOCK && block.getBlockData() instanceof WallSign) {
            this.handleSignClick(event, player, block, true);
        }
    }

    private void handleSignClick(PlayerInteractEvent event, Player player, Block block, boolean leftClick) {
        String itemName;
        ItemStack item;
        Portal portal = PortalHandler.getByBlock(block);
        if (portal == null) {
            return;
        }
        EquipmentSlot hand = event.getHand();
        if (hand != null && (PermissionHelper.hasPermission(player, "stargate.admin.dye") || portal.isOwner(player)) && (item = player.getInventory().getItem(hand)) != null && ((itemName = item.getType().toString()).endsWith("DYE") || itemName.endsWith("INK_SAC"))) {
            event.setUseInteractedBlock(Event.Result.ALLOW);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Stargate.getInstance(), portal::drawSign, 1L);
            return;
        }
        event.setUseInteractedBlock(Event.Result.DENY);
        if (leftClick) {
            if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
                event.setCancelled(true);
            }
        } else {
            event.setUseItemInHand(Event.Result.DENY);
        }
        if (this.cannotAccessPortal(player, portal)) {
            return;
        }
        if (!portal.isOpen() && !portal.getOptions().isFixed()) {
            PortalActivator destinations = portal.getPortalActivator();
            if (leftClick) {
                destinations.cycleDestination(player, -1);
            } else {
                destinations.cycleDestination(player);
            }
        }
    }

    private boolean cannotAccessPortal(Player player, Portal portal) {
        boolean deny = PermissionHelper.cannotAccessNetwork(player, portal.getCleanNetwork());
        if (PermissionHelper.portalAccessDenied(player, portal, deny)) {
            if (!portal.getOptions().isSilent()) {
                Stargate.getMessageSender().sendErrorMessage((CommandSender)player, Stargate.getString("denyMsg"));
            }
            return true;
        }
        return false;
    }

    private void handleRightClickBlock(PlayerInteractEvent event, Player player, Block block, EquipmentSlot hand) {
        if (block.getBlockData() instanceof WallSign) {
            this.handleSignClick(event, player, block, false);
            return;
        }
        if (this.clickIsBug(event.getPlayer(), block)) {
            return;
        }
        if (MaterialHelper.isButtonCompatible(block.getType())) {
            Portal portal = PortalHandler.getByBlock(block);
            if (portal == null) {
                return;
            }
            event.setUseItemInHand(Event.Result.DENY);
            event.setUseInteractedBlock(Event.Result.DENY);
            if (this.cannotAccessPortal(player, portal)) {
                return;
            }
            PermissionHelper.openPortal(player, portal);
            if (portal.getPortalOpener().isOpenFor(player) && !MaterialHelper.isContainer(block.getType())) {
                event.setUseInteractedBlock(Event.Result.ALLOW);
            }
        } else {
            ItemStack heldItem = player.getInventory().getItem(hand);
            if (heldItem != null && (heldItem.getType().isAir() || !heldItem.getType().isBlock())) {
                this.displayPortalInfo(block, player);
            }
        }
    }

    private void displayPortalInfo(Block block, Player player) {
        Portal portal = PortalHandler.getByBlock(block);
        if (portal == null) {
            return;
        }
        if (portal.getOptions().hasNoSign() && (!portal.getOptions().isSilent() || player.isSneaking())) {
            MessageSender sender = Stargate.getMessageSender();
            sender.sendSuccessMessage((CommandSender)player, ChatColor.GOLD + Stargate.getString("portalInfoTitle"));
            sender.sendSuccessMessage((CommandSender)player, Stargate.replaceVars(Stargate.getString("portalInfoName"), "%name%", portal.getName()));
            sender.sendSuccessMessage((CommandSender)player, Stargate.replaceVars(Stargate.getString("portalInfoDestination"), "%destination%", portal.getDestinationName()));
            if (portal.getOptions().isBungee()) {
                sender.sendSuccessMessage((CommandSender)player, Stargate.replaceVars(Stargate.getString("portalInfoServer"), "%server%", portal.getNetwork()));
            } else {
                sender.sendSuccessMessage((CommandSender)player, Stargate.replaceVars(Stargate.getString("portalInfoNetwork"), "%network%", portal.getNetwork()));
            }
        }
    }

    private boolean clickIsBug(Player player, Block block) {
        Long previousEventTime = previousEventTimes.get(player);
        if (previousEventTime != null && previousEventTime + 50L > System.currentTimeMillis()) {
            previousEventTimes.put(player, null);
            return true;
        }
        previousEventTimes.put(player, System.currentTimeMillis());
        return false;
    }
}

