/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.listener;

import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.PortalHandler;
import net.knarcraft.stargate.portal.PortalRegistry;
import net.knarcraft.stargate.utility.EntityHelper;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPortalEvent;

public class EntityEventListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onPortalEvent(EntityPortalEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (PortalHandler.getByAdjacentEntrance(event.getFrom(), EntityHelper.getEntityMaxSizeInt(entity)) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        for (Block block : event.blockList()) {
            Portal portal = PortalHandler.getByBlock(block);
            if (portal == null) continue;
            if (Stargate.getGateConfig().destroyedByExplosion()) {
                PortalRegistry.unregisterPortal(portal, true);
                continue;
            }
            event.setCancelled(true);
            break;
        }
    }
}

