/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.listener;

import java.util.List;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.container.BlockChangeRequest;
import net.knarcraft.stargate.event.StargateDestroyEvent;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.PortalCreator;
import net.knarcraft.stargate.portal.PortalHandler;
import net.knarcraft.stargate.portal.PortalRegistry;
import net.knarcraft.stargate.utility.EconomyHelper;
import net.knarcraft.stargate.utility.MaterialHelper;
import net.knarcraft.stargate.utility.PermissionHelper;
import net.knarcraft.stargate.utility.PortalFileHelper;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowman;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.plugin.Plugin;

public class BlockEventListener
implements Listener {
    @EventHandler
    public void onBlockFormedByEntity(EntityBlockFormEvent event) {
        if (event.isCancelled() || !Stargate.getGateConfig().protectEntrance() && !Stargate.getGateConfig().verifyPortals()) {
            return;
        }
        if (!(event.getEntity() instanceof Snowman)) {
            return;
        }
        if (PortalHandler.getByEntrance(event.getBlock()) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onSignChange(SignChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (!(block.getBlockData() instanceof WallSign)) {
            return;
        }
        Portal portal = new PortalCreator(event, player).createPortal();
        if (portal == null) {
            return;
        }
        if (portal.getOptions().hasNoSign()) {
            Material replaceMaterial = PortalFileHelper.decideRemovalMaterial(portal.getSignLocation(), portal);
            BlockChangeRequest request = new BlockChangeRequest(portal.getSignLocation(), replaceMaterial, null);
            Stargate.addBlockChangeRequest(request);
        }
        Stargate.getMessageSender().sendSuccessMessage((CommandSender)player, Stargate.getString("createMsg"));
        Stargate.debug("onSignChange", "Initialized stargate: " + portal.getName());
        Stargate.getInstance().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Stargate.getInstance(), portal::drawSign, 1L);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.isCancelled() || !Stargate.getGateConfig().protectEntrance()) {
            return;
        }
        Block block = event.getBlock();
        Player player = event.getPlayer();
        Portal portal = PortalHandler.getByEntrance(block);
        if (portal != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        Player player = event.getPlayer();
        Portal portal = PortalHandler.getByBlock(block);
        if (portal == null && Stargate.getGateConfig().protectEntrance()) {
            portal = PortalHandler.getByEntrance(block);
        }
        if (portal == null) {
            return;
        }
        boolean deny = false;
        String denyMessage = "";
        if (!PermissionHelper.canDestroyPortal(player, portal)) {
            denyMessage = Stargate.getString("denyMsg");
            deny = true;
            Stargate.logInfo(String.format("%s tried to destroy gate", player.getName()));
        }
        int cost = Stargate.getEconomyConfig().getDestroyCost(player, portal.getGate());
        StargateDestroyEvent destroyEvent = new StargateDestroyEvent(portal, player, deny, denyMessage, cost);
        Stargate.getInstance().getServer().getPluginManager().callEvent((Event)destroyEvent);
        if (destroyEvent.isCancelled()) {
            event.setCancelled(true);
            return;
        }
        if (destroyEvent.getDeny()) {
            if (!destroyEvent.getDenyReason().trim().isEmpty()) {
                Stargate.getMessageSender().sendErrorMessage((CommandSender)player, destroyEvent.getDenyReason());
            }
            event.setCancelled(true);
            return;
        }
        if (!this.handleEconomyPayment(destroyEvent, player, portal, event)) {
            return;
        }
        PortalRegistry.unregisterPortal(portal, true);
        Stargate.getMessageSender().sendSuccessMessage((CommandSender)player, Stargate.getString("destroyMsg"));
    }

    private boolean handleEconomyPayment(StargateDestroyEvent destroyEvent, Player player, Portal portal, BlockBreakEvent event) {
        int cost = destroyEvent.getCost();
        if (cost != 0) {
            String portalName = portal.getName();
            if (!EconomyHelper.chargePlayerIfNecessary(player, cost)) {
                Stargate.debug("onBlockBreak", "Insufficient Funds");
                EconomyHelper.sendInsufficientFundsMessage(portalName, player, cost);
                event.setCancelled(true);
                return false;
            }
            if (cost > 0) {
                EconomyHelper.sendDeductMessage(portalName, player, cost);
            } else {
                EconomyHelper.sendRefundMessage(portalName, player, cost);
            }
        }
        return true;
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        Block block = event.getBlock();
        Portal portal = null;
        if (block.getType() == Material.NETHER_PORTAL) {
            portal = PortalHandler.getByEntrance(block);
        } else if (MaterialHelper.isButtonCompatible(block.getType())) {
            portal = PortalHandler.getByControl(block);
        }
        if (portal != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockFromTo(BlockFromToEvent event) {
        Portal portal = PortalHandler.getByEntrance(event.getBlock());
        if (portal != null) {
            event.setCancelled(event.getBlock().getY() == event.getToBlock().getY());
        }
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent event) {
        this.cancelPistonEvent((BlockPistonEvent)event, event.getBlocks());
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent event) {
        if (!event.isSticky()) {
            return;
        }
        this.cancelPistonEvent((BlockPistonEvent)event, event.getBlocks());
    }

    private void cancelPistonEvent(BlockPistonEvent event, List<Block> blocks) {
        for (Block block : blocks) {
            Portal portal = PortalHandler.getByBlock(block);
            if (portal == null) continue;
            event.setCancelled(true);
            return;
        }
    }
}

