/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.container;

import net.knarcraft.stargate.utility.ColorHelper;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.block.Sign;

public class SignData {
    private final Sign sign;
    private final ChatColor mainSignColor;
    private final ChatColor highlightSignColor;
    private final DyeColor dyedColor;

    public SignData(Sign sign, ChatColor mainSignColor, ChatColor highlightSignColor) {
        this.sign = sign;
        this.mainSignColor = mainSignColor;
        this.highlightSignColor = highlightSignColor;
        this.dyedColor = sign.getColor();
    }

    public Sign getSign() {
        return this.sign;
    }

    public ChatColor getMainSignColor() {
        if (this.dyedColor != DyeColor.BLACK) {
            return ColorHelper.fromColor(this.dyedColor.getColor());
        }
        return this.mainSignColor;
    }

    public ChatColor getHighlightSignColor() {
        if (this.dyedColor != DyeColor.BLACK) {
            return ColorHelper.fromColor(ColorHelper.invert(this.dyedColor.getColor()));
        }
        return this.highlightSignColor;
    }
}

