/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.container;

public class RelativeBlockVector {
    private final int right;
    private final int down;
    private final int out;

    public RelativeBlockVector(int right, int down, int out) {
        this.right = right;
        this.down = down;
        this.out = out;
    }

    public RelativeBlockVector addToVector(Property propertyToAddTo, int valueToAdd) {
        return switch (propertyToAddTo) {
            default -> throw new IncompatibleClassChangeError();
            case Property.RIGHT -> new RelativeBlockVector(this.right + valueToAdd, this.down, this.out);
            case Property.DOWN -> new RelativeBlockVector(this.right, this.down + valueToAdd, this.out);
            case Property.OUT -> new RelativeBlockVector(this.right, this.down, this.out + valueToAdd);
        };
    }

    public RelativeBlockVector invert() {
        return new RelativeBlockVector(-this.right, -this.down, -this.out);
    }

    public int getRight() {
        return this.right;
    }

    public int getDown() {
        return this.down;
    }

    public int getOut() {
        return this.out;
    }

    public String toString() {
        return String.format("(right = %d, down = %d, out = %d)", this.right, this.down, this.out);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RelativeBlockVector otherVector = (RelativeBlockVector)other;
        return this.right == otherVector.right && this.down == otherVector.down && this.out == otherVector.out;
    }

    public static enum Property {
        RIGHT,
        DOWN,
        OUT;

    }
}

