/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.container;

import org.bukkit.Chunk;
import org.jetbrains.annotations.NotNull;

public class ChunkUnloadRequest
implements Comparable<ChunkUnloadRequest> {
    private final Long unloadNanoTime;
    private final Chunk chunkToUnload;

    public ChunkUnloadRequest(Chunk chunkToUnload, Long timeUntilUnload) {
        this.chunkToUnload = chunkToUnload;
        long systemNanoTime = System.nanoTime();
        this.unloadNanoTime = systemNanoTime + timeUntilUnload * 1000000L;
    }

    public Chunk getChunkToUnload() {
        return this.chunkToUnload;
    }

    public Long getUnloadNanoTime() {
        return this.unloadNanoTime;
    }

    public String toString() {
        return "{" + this.chunkToUnload + ", " + this.unloadNanoTime + "}";
    }

    @Override
    public int compareTo(@NotNull ChunkUnloadRequest otherRequest) {
        return this.unloadNanoTime.compareTo(otherRequest.unloadNanoTime);
    }
}

