/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.container;

import net.knarcraft.stargate.container.RelativeBlockVector;
import net.knarcraft.stargate.utility.DirectionHelper;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Sign;
import org.bukkit.util.Vector;

public class BlockLocation
extends Location {
    private BlockLocation parent = null;

    public BlockLocation(World world, int x, int y, int z) {
        super(world, (double)x, (double)y, (double)z);
    }

    public BlockLocation(Block block) {
        super(block.getWorld(), (double)block.getX(), (double)block.getY(), (double)block.getZ());
    }

    public BlockLocation(World world, String string) {
        super(world, (double)Integer.parseInt(string.split(",")[0]), (double)Integer.parseInt(string.split(",")[1]), (double)Integer.parseInt(string.split(",")[2]));
    }

    public BlockLocation makeRelativeBlockLocation(int x, int y, int z) {
        return (BlockLocation)this.clone().add((double)x, (double)y, (double)z);
    }

    public Location makeRelativeLocation(double x, double y, double z, float yaw) {
        Location newLocation = this.clone();
        newLocation.setYaw(yaw);
        newLocation.setPitch(0.0f);
        return newLocation.add(x, y, z);
    }

    public BlockLocation getRelativeLocation(RelativeBlockVector relativeVector, double yaw) {
        Vector realVector = DirectionHelper.getCoordinateVectorFromRelativeVector(relativeVector.getRight(), relativeVector.getDown(), relativeVector.getOut(), yaw);
        return this.makeRelativeBlockLocation(realVector.getBlockX(), realVector.getBlockY(), realVector.getBlockZ());
    }

    public Location getRelativeLocation(double right, double down, double out, float portalYaw) {
        Vector realVector = DirectionHelper.getCoordinateVectorFromRelativeVector(right, down, out, portalYaw);
        return this.makeRelativeLocation(0.5 + (double)realVector.getBlockX(), realVector.getBlockY(), 0.5 + (double)realVector.getBlockZ(), portalYaw);
    }

    public Material getType() {
        return this.getBlock().getType();
    }

    public void setType(Material type) {
        this.getBlock().setType(type);
    }

    public Location getLocation() {
        return this.clone();
    }

    public Block getParent() {
        if (this.parent == null) {
            this.findParent();
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getBlock();
    }

    private void findParent() {
        int offsetX = 0;
        int offsetY = 0;
        int offsetZ = 0;
        BlockData blockData = this.getBlock().getBlockData();
        if (blockData instanceof Directional) {
            BlockFace facing = ((Directional)blockData).getFacing().getOppositeFace();
            offsetX = facing.getModX();
            offsetZ = facing.getModZ();
        } else if (blockData instanceof Sign) {
            offsetY = -1;
        } else {
            return;
        }
        this.parent = this.makeRelativeBlockLocation(offsetX, offsetY, offsetZ);
    }

    public String toString() {
        return String.valueOf(this.getBlockX()) + "," + this.getBlockY() + "," + this.getBlockZ();
    }

    public int hashCode() {
        int result = 18;
        result = result * 27 + this.getBlockX();
        result = result * 27 + this.getBlockY();
        result = result * 27 + this.getBlockZ();
        if (this.getWorld() != null) {
            result = result * 27 + this.getWorld().getName().hashCode();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        BlockLocation blockLocation = (BlockLocation)((Object)object);
        World thisWorld = this.getWorld();
        World otherWorld = blockLocation.getWorld();
        boolean worldsEqual = thisWorld == null && otherWorld == null || thisWorld != null && otherWorld != null && thisWorld == otherWorld;
        return blockLocation.getBlockX() == this.getBlockX() && blockLocation.getBlockY() == this.getBlockY() && blockLocation.getBlockZ() == this.getBlockZ() && worldsEqual;
    }
}

