/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.config;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.config.ConfigOption;
import net.knarcraft.stargate.portal.PortalSignDrawer;
import net.knarcraft.stargate.utility.ColorHelper;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;

public final class StargateGateConfig {
    private static final int activeTime = 10;
    private static final int openTime = 10;
    private final Map<ConfigOption, Object> configOptions;

    public StargateGateConfig(Map<ConfigOption, Object> configOptions) {
        this.configOptions = configOptions;
        this.loadGateConfig();
    }

    public int getOpenTime() {
        return 10;
    }

    public int getActiveTime() {
        return 10;
    }

    public int maxGatesEachNetwork() {
        return (Integer)this.configOptions.get((Object)ConfigOption.MAX_GATES_EACH_NETWORK);
    }

    public boolean rememberDestination() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.REMEMBER_DESTINATION);
    }

    public boolean handleVehicles() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.HANDLE_VEHICLES);
    }

    public boolean handleEmptyVehicles() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.HANDLE_EMPTY_VEHICLES);
    }

    public boolean handleCreatureTransportation() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.HANDLE_CREATURE_TRANSPORTATION);
    }

    public boolean handleNonPlayerVehicles() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.HANDLE_NON_PLAYER_VEHICLES);
    }

    public boolean handleLeashedCreatures() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.HANDLE_LEASHED_CREATURES);
    }

    public boolean enableCraftBookRemoveOnEjectFix() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.ENABLE_CRAFT_BOOK_REMOVE_ON_EJECT_FIX);
    }

    public int waitForPlayerAfterTeleportDelay() {
        if ((Integer)this.configOptions.get((Object)ConfigOption.WAIT_FOR_PLAYER_AFTER_TELEPORT_DELAY) < 2) {
            this.configOptions.put(ConfigOption.WAIT_FOR_PLAYER_AFTER_TELEPORT_DELAY, 6);
        }
        return (Integer)this.configOptions.get((Object)ConfigOption.WAIT_FOR_PLAYER_AFTER_TELEPORT_DELAY);
    }

    public boolean sortNetworkDestinations() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.SORT_NETWORK_DESTINATIONS);
    }

    public boolean protectEntrance() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.PROTECT_ENTRANCE);
    }

    public boolean enableBungee() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.ENABLE_BUNGEE);
    }

    public boolean verifyPortals() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.VERIFY_PORTALS);
    }

    public boolean destroyedByExplosion() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.DESTROYED_BY_EXPLOSION);
    }

    public String getDefaultPortalNetwork() {
        return (String)this.configOptions.get((Object)ConfigOption.DEFAULT_GATE_NETWORK);
    }

    public double getExitVelocity() {
        return (Double)this.configOptions.get((Object)ConfigOption.EXIT_VELOCITY);
    }

    private void loadGateConfig() {
        String mainSignColor = (String)this.configOptions.get((Object)ConfigOption.MAIN_SIGN_COLOR);
        String highlightSignColor = (String)this.configOptions.get((Object)ConfigOption.HIGHLIGHT_SIGN_COLOR);
        this.loadPerSignColor(mainSignColor, highlightSignColor);
        this.loadPerSignColors();
    }

    public void loadPerSignColors() {
        List perSignColors = (List)this.configOptions.get((Object)ConfigOption.PER_SIGN_COLORS);
        ChatColor[] defaultColors = new ChatColor[]{PortalSignDrawer.getMainColor(), PortalSignDrawer.getHighlightColor()};
        ArrayList<Map<Material, ChatColor>> colorMaps = new ArrayList<Map<Material, ChatColor>>();
        colorMaps.add(new HashMap());
        colorMaps.add(new HashMap());
        for (Object signColorSpecification : perSignColors) {
            this.parsePerSignColors(signColorSpecification, defaultColors, colorMaps);
        }
        PortalSignDrawer.setPerSignMainColors((Map)colorMaps.get(0));
        PortalSignDrawer.setPerSignHighlightColors((Map)colorMaps.get(1));
    }

    private void parsePerSignColors(Object signColorSpecification, ChatColor[] defaultColors, List<Map<Material, ChatColor>> colorMaps) {
        String[] specificationData = String.valueOf(signColorSpecification).split(":");
        Material[] signMaterials = new Material[]{Material.matchMaterial((String)(specificationData[0] + "_SIGN")), Material.matchMaterial((String)(specificationData[0] + "_WALL_SIGN"))};
        if (specificationData.length != 2) {
            Stargate.logWarning("You have an invalid per-sign line in your config.yml file. Please fix it!");
            return;
        }
        String[] colors = specificationData[1].split(",");
        if (colors.length != 2) {
            Stargate.logWarning("You have an invalid per-sign line in your config.yml file. Please fix it!");
            return;
        }
        for (int colorIndex = 0; colorIndex < 2; ++colorIndex) {
            if (colors[colorIndex].equalsIgnoreCase("default")) continue;
            this.loadPerSignColor(colors, colorIndex, defaultColors, signMaterials, colorMaps);
        }
    }

    private void loadPerSignColor(String[] colors, int colorIndex, ChatColor[] defaultColors, Material[] signMaterials, List<Map<Material, ChatColor>> colorMaps) {
        ChatColor parsedColor;
        if (colors[colorIndex].equalsIgnoreCase("inverted")) {
            Color color = defaultColors[colorIndex].getColor();
            parsedColor = ColorHelper.fromColor(ColorHelper.invert(org.bukkit.Color.fromRGB((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue())));
        } else {
            try {
                parsedColor = ChatColor.of((String)colors[colorIndex]);
            }
            catch (IllegalArgumentException | NullPointerException exception) {
                Stargate.logWarning("You have specified an invalid per-sign color in your config.yml. Custom color for \"" + signMaterials[0] + "\" disabled");
                return;
            }
        }
        if (parsedColor != null) {
            for (Material signMaterial : signMaterials) {
                colorMaps.get(colorIndex).put(signMaterial, parsedColor);
            }
        }
    }

    private void loadPerSignColor(String mainSignColor, String highlightSignColor) {
        try {
            PortalSignDrawer.setMainColor(ChatColor.of((String)mainSignColor.toUpperCase()));
        }
        catch (IllegalArgumentException | NullPointerException exception) {
            Stargate.logWarning("You have specified an invalid main sign color in your config.yml. Defaulting to BLACK");
            PortalSignDrawer.setMainColor(ChatColor.BLACK);
        }
        try {
            PortalSignDrawer.setHighlightColor(ChatColor.of((String)highlightSignColor.toUpperCase()));
        }
        catch (IllegalArgumentException | NullPointerException exception) {
            Stargate.logWarning("You have specified an invalid highlighting sign color in your config.yml. Defaulting to WHITE");
            PortalSignDrawer.setHighlightColor(ChatColor.WHITE);
        }
    }
}

