/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.config;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.config.ConfigOption;
import net.knarcraft.stargate.config.DynmapManager;
import net.knarcraft.stargate.config.EconomyConfig;
import net.knarcraft.stargate.config.LanguageLoader;
import net.knarcraft.stargate.config.MessageSender;
import net.knarcraft.stargate.config.OptionDataType;
import net.knarcraft.stargate.config.StargateGateConfig;
import net.knarcraft.stargate.container.BlockChangeRequest;
import net.knarcraft.stargate.listener.BungeeCordListener;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.PortalHandler;
import net.knarcraft.stargate.portal.PortalRegistry;
import net.knarcraft.stargate.portal.property.gate.GateHandler;
import net.knarcraft.stargate.thread.BlockChangeThread;
import net.knarcraft.stargate.utility.FileHelper;
import net.knarcraft.stargate.utility.PortalFileHelper;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.dynmap.DynmapAPI;

public final class StargateConfig {
    private final Queue<Portal> activePortalsQueue = new ConcurrentLinkedQueue<Portal>();
    private final Queue<Portal> openPortalsQueue = new ConcurrentLinkedQueue<Portal>();
    private final HashSet<String> managedWorlds = new HashSet();
    private StargateGateConfig stargateGateConfig;
    private MessageSender messageSender;
    private final LanguageLoader languageLoader;
    private EconomyConfig economyConfig;
    private final Logger logger;
    private final String dataFolderPath;
    private String gateFolder;
    private String portalFolder;
    private String languageName = "en";
    private final Map<ConfigOption, Object> configOptions;

    public StargateConfig(Logger logger) {
        this.logger = logger;
        this.configOptions = new HashMap<ConfigOption, Object>();
        this.dataFolderPath = Stargate.getInstance().getDataFolder().getPath().replaceAll("\\\\", "/");
        this.portalFolder = this.dataFolderPath + "/portals/";
        this.gateFolder = this.dataFolderPath + "/gates/";
        this.languageLoader = new LanguageLoader(this.dataFolderPath + "/lang/");
    }

    public Map<ConfigOption, Object> getConfigOptionsReference() {
        return this.configOptions;
    }

    public void finishSetup() {
        this.loadConfig();
        if (this.stargateGateConfig.enableBungee()) {
            this.startStopBungeeListener(true);
        }
        this.languageLoader.setChosenLanguage(this.languageName);
        this.languageLoader.reload();
        this.messageSender = new MessageSender(this.languageLoader);
        if (this.isDebuggingEnabled()) {
            this.languageLoader.debug();
        }
        this.createMissingFolders();
        this.loadGates();
        this.loadAllPortals();
        this.setupVaultEconomy();
        DynmapAPI dynmapAPI = (DynmapAPI)Bukkit.getPluginManager().getPlugin("dynmap");
        if (dynmapAPI != null) {
            DynmapManager.initialize(dynmapAPI);
            DynmapManager.addAllPortalMarkers();
        }
    }

    public Map<ConfigOption, Object> getConfigOptions() {
        return new HashMap<ConfigOption, Object>(this.configOptions);
    }

    public Queue<Portal> getOpenPortalsQueue() {
        return this.openPortalsQueue;
    }

    public Queue<Portal> getActivePortalsQueue() {
        return this.activePortalsQueue;
    }

    public boolean isDebuggingEnabled() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.DEBUG);
    }

    public boolean isPermissionDebuggingEnabled() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.PERMISSION_DEBUG);
    }

    public boolean isDynmapDisabled() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.ENABLE_DYNMAP) == false;
    }

    public boolean hideDynmapIcons() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.DYNMAP_ICONS_DEFAULT_HIDDEN);
    }

    public EconomyConfig getEconomyConfig() {
        return this.economyConfig;
    }

    public void reload(CommandSender sender) {
        this.unload();
        BlockChangeRequest firstElement = Stargate.getBlockChangeRequestQueue().peek();
        while (firstElement != null) {
            BlockChangeThread.pollQueue();
            firstElement = Stargate.getBlockChangeRequestQueue().peek();
        }
        boolean oldEnableBungee = this.stargateGateConfig.enableBungee();
        this.load();
        if (oldEnableBungee != this.stargateGateConfig.enableBungee()) {
            this.startStopBungeeListener(this.stargateGateConfig.enableBungee());
        }
        DynmapManager.addAllPortalMarkers();
        this.messageSender.sendErrorMessage(sender, this.languageLoader.getString("reloaded"));
    }

    private void unload() {
        this.unloadAllPortals();
        GateHandler.clearGates();
    }

    public void unloadAllPortals() {
        for (Portal activePortal : this.activePortalsQueue) {
            activePortal.getPortalActivator().deactivate();
        }
        this.closeAllOpenPortals();
        PortalHandler.closeAllPortals();
        this.activePortalsQueue.clear();
        this.openPortalsQueue.clear();
        this.managedWorlds.clear();
        PortalRegistry.clearPortals();
    }

    public void clearManagedWorlds() {
        this.managedWorlds.clear();
    }

    public Set<String> getManagedWorlds() {
        return new HashSet<String>(this.managedWorlds);
    }

    public void addManagedWorld(String worldName) {
        this.managedWorlds.add(worldName);
    }

    public void removeManagedWorld(String worldName) {
        this.managedWorlds.remove(worldName);
    }

    private void load() {
        this.loadConfig();
        this.loadGates();
        this.loadAllPortals();
        this.languageLoader.setChosenLanguage(this.languageName);
        this.languageLoader.reload();
        if (this.isDebuggingEnabled()) {
            this.languageLoader.debug();
        }
        this.reloadEconomy();
    }

    public void startStopBungeeListener(boolean start) {
        Messenger messenger = Bukkit.getMessenger();
        String bungeeChannel = "BungeeCord";
        if (start) {
            messenger.registerOutgoingPluginChannel((Plugin)Stargate.getInstance(), bungeeChannel);
            messenger.registerIncomingPluginChannel((Plugin)Stargate.getInstance(), bungeeChannel, (PluginMessageListener)new BungeeCordListener());
        } else {
            messenger.unregisterIncomingPluginChannel((Plugin)Stargate.getInstance(), bungeeChannel);
            messenger.unregisterOutgoingPluginChannel((Plugin)Stargate.getInstance(), bungeeChannel);
        }
    }

    public void reloadEconomy() {
        EconomyConfig economyConfig = this.getEconomyConfig();
        if (economyConfig.isEconomyEnabled() && economyConfig.getEconomy() == null) {
            this.setupVaultEconomy();
        } else if (!economyConfig.isEconomyEnabled()) {
            economyConfig.disableEconomy();
        }
    }

    public void closeAllOpenPortals() {
        for (Portal openPortal : this.openPortalsQueue) {
            openPortal.getPortalOpener().closePortal(false);
        }
    }

    public boolean alertAdminsAboutUpdates() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.ADMIN_UPDATE_ALERT);
    }

    public void loadConfig() {
        Stargate.getInstance().reloadConfig();
        FileConfiguration newConfig = Stargate.getInstance().getConfig();
        boolean isMigrating = false;
        if (newConfig.getString("lang") != null || newConfig.getString("economy.freeGatesGreen") != null) {
            this.migrateConfig(newConfig);
            isMigrating = true;
        }
        newConfig.options().copyDefaults(true);
        for (ConfigOption option : ConfigOption.values()) {
            String configNode = option.getConfigNode();
            this.configOptions.put(option, switch (option.getDataType()) {
                case OptionDataType.STRING_LIST -> newConfig.getStringList(configNode);
                case OptionDataType.STRING -> {
                    String value = newConfig.getString(configNode);
                    yield value != null ? value.trim() : "";
                }
                case OptionDataType.BOOLEAN -> newConfig.getBoolean(configNode);
                case OptionDataType.INTEGER -> newConfig.getInt(configNode);
                case OptionDataType.DOUBLE -> newConfig.getDouble(configNode);
                default -> throw new IllegalArgumentException("Invalid config data type encountered");
            });
        }
        this.languageName = (String)this.configOptions.get((Object)ConfigOption.LANGUAGE);
        this.portalFolder = (String)this.configOptions.get((Object)ConfigOption.PORTAL_FOLDER);
        this.gateFolder = (String)this.configOptions.get((Object)ConfigOption.GATE_FOLDER);
        if (isMigrating) {
            GateHandler.writeDefaultGatesToFolder(this.gateFolder);
        }
        this.stargateGateConfig = new StargateGateConfig(this.configOptions);
        this.economyConfig = new EconomyConfig(this.configOptions);
        Stargate.getInstance().saveConfig();
    }

    public StargateGateConfig getStargateGateConfig() {
        return this.stargateGateConfig;
    }

    public void loadGates() {
        GateHandler.loadGates(this.gateFolder);
        Stargate.logInfo(String.format("Loaded %s gate layouts", GateHandler.getGateCount()));
    }

    private void migrateConfig(FileConfiguration newConfig) {
        Map<String, String> migrationFields;
        try {
            newConfig.save(this.dataFolderPath + "/config.yml.old");
        }
        catch (IOException e) {
            Stargate.debug("Stargate::migrateConfig", "Unable to save old backup and do migration");
            e.printStackTrace();
            return;
        }
        try {
            migrationFields = FileHelper.readKeyValuePairs(FileHelper.getBufferedReaderFromInputStream(FileHelper.getInputStreamForInternalFile("/config-migrations.txt")));
        }
        catch (IOException e) {
            Stargate.debug("Stargate::migrateConfig", "Unable to load config migration file");
            e.printStackTrace();
            return;
        }
        for (String key : migrationFields.keySet()) {
            if (!newConfig.contains(key)) continue;
            String newPath = migrationFields.get(key);
            Object oldValue = newConfig.get(key);
            if (!newPath.trim().isEmpty()) {
                newConfig.set(newPath, oldValue);
            }
            newConfig.set(key, null);
        }
    }

    private void setupVaultEconomy() {
        EconomyConfig economyConfig = this.getEconomyConfig();
        if (economyConfig.setupEconomy(Stargate.getPluginManager()) && economyConfig.getEconomy() != null) {
            String vaultVersion = economyConfig.getVault().getDescription().getVersion();
            Stargate.logInfo(Stargate.replaceVars(Stargate.getString("vaultLoaded"), "%version%", vaultVersion));
        }
    }

    public void loadAllPortals() {
        for (World world : Stargate.getInstance().getServer().getWorlds()) {
            if (this.managedWorlds.contains(world.getName())) continue;
            PortalFileHelper.loadAllPortals(world);
            this.managedWorlds.add(world.getName());
        }
    }

    private void createMissingFolders() {
        File newFile;
        File newPortalDir = new File(this.portalFolder);
        if (!newPortalDir.exists() && !newPortalDir.mkdirs()) {
            this.logger.severe("Unable to create portal directory");
        }
        if (!((newFile = new File(this.portalFolder, ((World)Stargate.getInstance().getServer().getWorlds().get(0)).getName() + ".db")).exists() || newFile.getParentFile().exists() || newFile.getParentFile().mkdirs())) {
            this.logger.severe("Unable to create portal database folder: " + newFile.getParentFile().getPath());
        }
    }

    public String getPortalFolder() {
        return this.portalFolder;
    }

    public String getGateFolder() {
        return this.gateFolder;
    }

    public MessageSender getMessageSender() {
        return this.messageSender;
    }

    public LanguageLoader getLanguageLoader() {
        return this.languageLoader;
    }
}

