/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.utility.FileHelper;

public final class LanguageLoader {
    private final String languageFolder;
    private final Map<String, String> loadedBackupStrings;
    private String chosenLanguage;
    private Map<String, String> loadedStringTranslations;

    public LanguageLoader(String languageFolder) {
        InputStream inputStream;
        this.languageFolder = languageFolder;
        File testFile = new File(languageFolder, "en.txt");
        if (!testFile.exists() && testFile.getParentFile().mkdirs()) {
            Stargate.debug("LanguageLoader", "Created language folder");
        }
        if ((inputStream = FileHelper.getInputStreamForInternalFile("/lang/en.txt")) != null) {
            this.loadedBackupStrings = this.load("en", inputStream);
        } else {
            this.loadedBackupStrings = null;
            Stargate.getConsoleLogger().severe("[stargate] Error loading backup language. There may be missing text in-game");
        }
    }

    public void reload() {
        this.updateLanguage(this.chosenLanguage);
        this.loadedStringTranslations = this.load(this.chosenLanguage);
    }

    public String getString(String name) {
        String value = null;
        if (this.loadedStringTranslations != null) {
            value = this.loadedStringTranslations.get(name);
        }
        if (value == null) {
            value = this.getBackupString(name);
        }
        return value;
    }

    public String getBackupString(String name) {
        String value = null;
        if (this.loadedBackupStrings != null) {
            value = this.loadedBackupStrings.get(name);
        }
        if (value == null) {
            return "";
        }
        return value;
    }

    public void setChosenLanguage(String chosenLanguage) {
        this.chosenLanguage = chosenLanguage;
    }

    private void updateLanguage(String language) {
        Map<String, String> currentLanguageValues = this.load(language);
        InputStream inputStream = this.getClass().getResourceAsStream("/lang/" + language + ".txt");
        if (inputStream == null) {
            Stargate.logInfo(String.format("The language %s is not available. Falling back to english, You can add a custom language by creating a new text file in the lang directory.", language));
            Stargate.debug("LanguageLoader::updateLanguage", String.format("Unable to load /lang/%s.txt", language));
            return;
        }
        try {
            this.readChangedLanguageStrings(inputStream, language, currentLanguageValues);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void readChangedLanguageStrings(InputStream inputStream, String language, Map<String, String> currentLanguageValues) throws IOException {
        BufferedReader bufferedReader = FileHelper.getBufferedReaderFromInputStream(inputStream);
        Map<String, String> internalLanguageValues = FileHelper.readKeyValuePairs(bufferedReader);
        if (currentLanguageValues == null) {
            this.updateLanguageFile(language, internalLanguageValues, null);
            Stargate.logInfo(String.format("Language (%s) has been loaded", language));
            return;
        }
        if (!internalLanguageValues.keySet().equals(currentLanguageValues.keySet())) {
            HashMap<String, String> newLanguageValues = new HashMap<String, String>();
            boolean updateNecessary = false;
            for (String key : internalLanguageValues.keySet()) {
                if (currentLanguageValues.get(key) == null) {
                    newLanguageValues.put(key, internalLanguageValues.get(key));
                    updateNecessary = true;
                    continue;
                }
                newLanguageValues.put(key, currentLanguageValues.get(key));
                currentLanguageValues.remove(key);
            }
            if (updateNecessary) {
                this.updateLanguageFile(language, newLanguageValues, currentLanguageValues);
                Stargate.logInfo(String.format("Your language file (%s.txt) has been updated", language));
            }
        }
    }

    private void updateLanguageFile(String language, Map<String, String> languageStrings, Map<String, String> customLanguageStrings) throws IOException {
        BufferedWriter bufferedWriter = FileHelper.getBufferedWriterFromString(this.languageFolder + language + ".txt");
        for (String key : languageStrings.keySet()) {
            bufferedWriter.write(key + "=" + languageStrings.get(key));
            bufferedWriter.newLine();
        }
        bufferedWriter.newLine();
        if (customLanguageStrings != null) {
            for (String key : customLanguageStrings.keySet()) {
                bufferedWriter.write(key + "=" + customLanguageStrings.get(key));
                bufferedWriter.newLine();
            }
        }
        bufferedWriter.close();
    }

    private Map<String, String> load(String lang) {
        return this.load(lang, null);
    }

    private Map<String, String> load(String lang, InputStream inputStream) {
        Map<String, String> strings;
        try {
            BufferedReader bufferedReader = inputStream == null ? FileHelper.getBufferedReaderFromString(this.languageFolder + lang + ".txt") : FileHelper.getBufferedReaderFromInputStream(inputStream);
            strings = FileHelper.readKeyValuePairs(bufferedReader);
        }
        catch (Exception e) {
            if (Stargate.getStargateConfig().isDebuggingEnabled()) {
                Stargate.getConsoleLogger().info("[Stargate] Unable to load language " + lang);
            }
            return null;
        }
        return strings;
    }

    public void debug() {
        Set<String> keys;
        if (this.loadedStringTranslations != null) {
            keys = this.loadedStringTranslations.keySet();
            for (String key : keys) {
                Stargate.debug("LanguageLoader::Debug::loadedStringTranslations", key + " => " + this.loadedStringTranslations.get(key));
            }
        }
        if (this.loadedBackupStrings == null) {
            return;
        }
        keys = this.loadedBackupStrings.keySet();
        for (String key : keys) {
            Stargate.debug("LanguageLoader::Debug::loadedBackupStrings", key + " => " + this.loadedBackupStrings.get(key));
        }
    }
}

