/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.config;

import java.util.Map;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.config.ConfigOption;
import net.knarcraft.stargate.portal.PortalSignDrawer;
import net.knarcraft.stargate.portal.property.gate.Gate;
import net.knarcraft.stargate.utility.PermissionHelper;
import net.md_5.bungee.api.ChatColor;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicesManager;

public final class EconomyConfig {
    private Economy economy = null;
    private Plugin vault = null;
    private final Map<ConfigOption, Object> configOptions;

    public EconomyConfig(Map<ConfigOption, Object> configOptions) {
        this.configOptions = configOptions;
        try {
            String freeColor = (String)configOptions.get((Object)ConfigOption.FREE_GATES_COLOR);
            PortalSignDrawer.setFreeColor(ChatColor.of((String)freeColor.toUpperCase()));
        }
        catch (IllegalArgumentException | NullPointerException ignored) {
            PortalSignDrawer.setFreeColor(ChatColor.DARK_GREEN);
        }
    }

    public int getDefaultUseCost() {
        return (Integer)this.configOptions.get((Object)ConfigOption.USE_COST);
    }

    public boolean isEconomyEnabled() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.USE_ECONOMY);
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public Plugin getVault() {
        return this.vault;
    }

    public void disableEconomy() {
        this.economy = null;
        this.vault = null;
    }

    public boolean drawFreePortalsColored() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.FREE_GATES_COLORED);
    }

    public boolean freeIfFreeDestination() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.CHARGE_FREE_DESTINATION) == false;
    }

    public boolean sendPaymentToOwner() {
        return (Boolean)this.configOptions.get((Object)ConfigOption.TO_OWNER);
    }

    public int getDefaultCreateCost() {
        return (Integer)this.configOptions.get((Object)ConfigOption.CREATE_COST);
    }

    public int getDefaultDestroyCost() {
        return (Integer)this.configOptions.get((Object)ConfigOption.DESTROY_COST);
    }

    public boolean canAffordFee(Player player, int cost) {
        return this.economy.getBalance((OfflinePlayer)player) > (double)cost;
    }

    public String format(int amount) {
        if (this.isEconomyEnabled()) {
            return this.economy.format((double)amount);
        }
        return "";
    }

    public boolean setupEconomy(PluginManager pluginManager) {
        if (!this.isEconomyEnabled()) {
            return false;
        }
        Plugin vault = pluginManager.getPlugin("Vault");
        if (vault != null && vault.isEnabled()) {
            ServicesManager servicesManager = Stargate.getInstance().getServer().getServicesManager();
            RegisteredServiceProvider economyProvider = servicesManager.getRegistration(Economy.class);
            if (economyProvider != null) {
                this.economy = (Economy)economyProvider.getProvider();
                this.vault = vault;
                return true;
            }
            Stargate.logInfo(Stargate.getString("ecoLoadError"));
        } else {
            Stargate.logInfo(Stargate.getString("vaultLoadError"));
        }
        this.configOptions.put(ConfigOption.USE_ECONOMY, false);
        return false;
    }

    public boolean useEconomy() {
        return this.isEconomyEnabled() && this.economy != null;
    }

    public int getCreateCost(Player player, Gate gate) {
        if (this.isFree(player, "create")) {
            return 0;
        }
        return gate.getCreateCost();
    }

    public int getDestroyCost(Player player, Gate gate) {
        if (this.isFree(player, "destroy")) {
            return 0;
        }
        return gate.getDestroyCost();
    }

    private boolean isFree(Player player, String permissionNode) {
        return !this.useEconomy() || PermissionHelper.hasPermission(player, "stargate.free." + permissionNode);
    }
}

