/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.config;

import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.container.BlockLocation;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.PortalRegistry;
import org.bukkit.World;
import org.dynmap.DynmapAPI;
import org.dynmap.markers.GenericMarker;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerIcon;
import org.dynmap.markers.MarkerSet;

public final class DynmapManager {
    private static MarkerSet markerSet;
    private static MarkerIcon portalIcon;

    private DynmapManager() {
    }

    public static void initialize(DynmapAPI dynmapAPI) {
        if (dynmapAPI == null) {
            markerSet = null;
            portalIcon = null;
        } else {
            markerSet = dynmapAPI.getMarkerAPI().createMarkerSet("stargate", "Stargate", null, false);
            markerSet.setHideByDefault(Stargate.getStargateConfig().hideDynmapIcons());
            portalIcon = dynmapAPI.getMarkerAPI().getMarkerIcon("portal");
        }
    }

    public static void addAllPortalMarkers() {
        if (markerSet == null || Stargate.getStargateConfig().isDynmapDisabled()) {
            if (markerSet != null) {
                markerSet.getMarkers().forEach(GenericMarker::deleteMarker);
            }
            return;
        }
        markerSet.setHideByDefault(Stargate.getStargateConfig().hideDynmapIcons());
        markerSet.getMarkers().forEach(GenericMarker::deleteMarker);
        for (Portal portal : PortalRegistry.getAllPortals()) {
            DynmapManager.addPortalMarker(portal);
        }
    }

    public static void addPortalMarker(Portal portal) {
        if (markerSet == null || Stargate.getStargateConfig().isDynmapDisabled()) {
            return;
        }
        World world = portal.getWorld();
        if (portal.getOptions().isHidden() || world == null) {
            return;
        }
        BlockLocation location = portal.getBlockAt(portal.getGate().getLayout().getExit());
        Marker marker = markerSet.createMarker(DynmapManager.getPortalMarkerId(portal), portal.getName(), world.getName(), location.getX(), location.getY(), location.getZ(), portalIcon, false);
        if (marker == null) {
            Stargate.logWarning(String.format("Unable to create marker for portal\nPortal marker id: %s\nPortal name: %s\nPortal world: %s\nPortal location: %s,%s,%s", DynmapManager.getPortalMarkerId(portal), portal.getName(), world.getName(), location.getX(), location.getY(), location.getZ()));
            return;
        }
        String networkPrompt = portal.getOptions().isBungee() ? "Server" : "Network";
        String markerDescription = String.format("<b>Name:</b> %s<br /><b>%s:</b> %s<br /><b>Destination:</b> %s<br /><b>Owner:</b> %s<br />", portal.getName(), networkPrompt, portal.getNetwork(), portal.getDestinationName(), portal.getOwner().getName());
        marker.setDescription(markerDescription);
        marker.setLabel(portal.getName(), true);
        marker.setMarkerIcon(portalIcon);
    }

    public static void removePortalMarker(Portal portal) {
        if (markerSet == null || Stargate.getStargateConfig().isDynmapDisabled()) {
            return;
        }
        Marker marker = markerSet.findMarker(DynmapManager.getPortalMarkerId(portal));
        if (marker != null) {
            marker.deleteMarker();
        }
    }

    private static String getPortalMarkerId(Portal portal) {
        return portal.getNetwork() + "-:-" + portal.getName();
    }
}

