/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.config;

import java.util.Arrays;
import net.knarcraft.stargate.config.ConfigOption;

public enum ConfigTag {
    COLOR(new ConfigOption[]{ConfigOption.FREE_GATES_COLOR, ConfigOption.MAIN_SIGN_COLOR, ConfigOption.HIGHLIGHT_SIGN_COLOR, ConfigOption.PER_SIGN_COLORS}),
    FOLDER(new ConfigOption[]{ConfigOption.GATE_FOLDER, ConfigOption.PORTAL_FOLDER}),
    DYNMAP(new ConfigOption[]{ConfigOption.ENABLE_DYNMAP, ConfigOption.DYNMAP_ICONS_DEFAULT_HIDDEN});

    private final ConfigOption[] taggedOptions;

    private ConfigTag(ConfigOption[] taggedOptions) {
        this.taggedOptions = taggedOptions;
    }

    public boolean isTagged(ConfigOption option) {
        return Arrays.stream(this.taggedOptions).anyMatch(item -> item == option);
    }

    public static boolean requiresColorReload(ConfigOption configOption) {
        return COLOR.isTagged(configOption) && configOption != ConfigOption.FREE_GATES_COLOR;
    }

    public static boolean requiresFullReload(ConfigOption option) {
        return FOLDER.isTagged(option);
    }

    public static boolean requiresDynmapReload(ConfigOption configOption) {
        return DYNMAP.isTagged(configOption);
    }

    public static boolean requiresPortalReload(ConfigOption option) {
        return COLOR.isTagged(option) || FOLDER.isTagged(option) || option == ConfigOption.VERIFY_PORTALS;
    }

    public static boolean requiresLanguageReload(ConfigOption option) {
        return option == ConfigOption.LANGUAGE;
    }

    public static boolean requiresEconomyReload(ConfigOption option) {
        return option == ConfigOption.USE_ECONOMY;
    }
}

